/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.exception;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessException
extends RuntimeException {
    private static final Logger log = LoggerFactory.getLogger(BusinessException.class);
    private static final long serialVersionUID = -1956089458134530038L;
    private String errorCode = "999";

    public BusinessException() {
    }

    public BusinessException(String errorCode, String message) {
        super(message);
        this.errorCode = errorCode;
        log.error("\u9519\u8bef\u4ee3\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)errorCode, (Object)message);
    }

    public BusinessException(String message, Throwable cause) {
        super(message, cause);
        log.error("\u9519\u8bef\u4fe1\u606f: {}, cause.getClass: {}, cause: {}", new Object[]{message, cause.getClass(), cause.getMessage()});
    }

    public BusinessException(String message) {
        super(message);
        log.error("\u9519\u8bef\u4ee3\u7801: {}, \u9519\u8bef\u4fe1\u606f: {}", (Object)this.errorCode, (Object)message);
    }

    public BusinessException(Throwable cause) {
        super(cause);
        log.error("cause.getClass: {}, cause: {}", cause.getClass(), (Object)cause.getMessage());
    }

    public String getErrorCode() {
        return this.errorCode;
    }
}

