/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.page.reslover.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.jumipm.common.page.reslover.JumiPageRequestReslover;
import com.jumipm.utils.DateUtils;
import com.jumipm.utils.StrUtil;
import com.kotelmems.platform.page.AgParm;
import com.kotelmems.platform.page.PageRequest;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgGridReslover
implements JumiPageRequestReslover {
    private static final Logger log = LoggerFactory.getLogger(AgGridReslover.class);
    private Map<String, ColsReslover> filterFunction = new HashMap<String, ColsReslover>();
    private Map<String, String> conditionSqlTemp = new HashMap<String, String>();
    private Map<String, String> timeConditionSqlTemp = new HashMap<String, String>();
    private Map<String, String> numberConditionSqlTemp = new HashMap<String, String>();
    private Map<String, String> valTemp = new HashMap<String, String>();
    private final String QUERYTYPE_NORMAL = "normal";
    private final String QUERYTYPE_CUSTOM = "custom";

    public AgGridReslover() {
        this.conditionSqlTemp.put("equals", " = :Key ");
        this.conditionSqlTemp.put("notEqual", " != :Key ");
        this.conditionSqlTemp.put("startswith", " like :Key ");
        this.conditionSqlTemp.put("endswith", " like :Key ");
        this.conditionSqlTemp.put("blank", " = '' ");
        this.conditionSqlTemp.put("notBlank", " <> '' ");
        this.conditionSqlTemp.put("empty", " is null ");
        this.conditionSqlTemp.put("contains", " like :Key ");
        this.conditionSqlTemp.put("notcontains", " not like :Key ");
        this.valTemp.put("equals", "Val");
        this.valTemp.put("notEqual", "Val");
        this.valTemp.put("startswith", "Val%");
        this.valTemp.put("endswith", "%Val");
        this.valTemp.put("contains", "%Val%");
        this.valTemp.put("notcontains", "%Val%");
        this.timeConditionSqlTemp.put("equals", " = :Key ");
        this.timeConditionSqlTemp.put("notEqual", " <> :Key ");
        this.timeConditionSqlTemp.put("greaterThan", " > :Key ");
        this.timeConditionSqlTemp.put("lessThan", " < :Key ");
        this.timeConditionSqlTemp.put("blank", " is null ");
        this.timeConditionSqlTemp.put("notBlank", " is not null ");
        this.timeConditionSqlTemp.put("inRange", " BETWEEN :Key AND :Key ");
        this.numberConditionSqlTemp.put("equals", " = :Key ");
        this.numberConditionSqlTemp.put("notEqual", " <> :Key ");
        this.numberConditionSqlTemp.put("greaterThan", " > :Key ");
        this.numberConditionSqlTemp.put("greaterThanOrEqual", " >= :Key ");
        this.numberConditionSqlTemp.put("lessThan", " < :Key ");
        this.numberConditionSqlTemp.put("lessThanOrEqual", " <= :Key ");
        this.numberConditionSqlTemp.put("blank", " is null ");
        this.numberConditionSqlTemp.put("notBlank", " is not null ");
        this.numberConditionSqlTemp.put("inRange", " BETWEEN :Key AND :Key ");
        this.filterFunction.put("text", new TextReslover());
        this.filterFunction.put("set", new SetReslover());
        this.filterFunction.put("date", new DateReslover());
        this.filterFunction.put("date_custom", new SqlDateReslover());
        this.filterFunction.put("number", new NumberReslover());
    }

    @Override
    public PageRequest resolveArgument(String parms) {
        PageRequest pageRequest = new PageRequest(1, 10);
        try {
            JSONObject agGridParam = JSONObject.parseObject((String)parms);
            int iDisplayStart = agGridParam.getInteger("startRow");
            int pageSize = agGridParam.getInteger("endRow") - iDisplayStart;
            int pageNum = (iDisplayStart + pageSize) / pageSize;
            pageRequest.setAgGridParam(agGridParam);
            pageRequest.setPageNumber(pageNum);
            pageRequest.setPageSize(pageSize);
            String queryType = agGridParam.getString("queryType");
            if (StrUtil.isNull(queryType)) {
                queryType = "normal";
            }
            AgParm agParm = this.initFilerColumnInfo(agGridParam.getJSONObject("filterModel"), queryType);
            pageRequest.setAgParm(agParm);
            String orderInfo = this.initOrderColumnInfo(agGridParam.getJSONArray("sortModel"), queryType);
            pageRequest.setSortColumns(orderInfo);
        }
        catch (Exception e) {
            log.error("\u5206\u9875\u53c2\u6570\u89e3\u6790\u51fa\u9519\uff1a{}", (Object)e.getMessage());
            e.printStackTrace();
        }
        return pageRequest;
    }

    public AgParm initFilerColumnInfo(JSONObject filterModel, String queryType, Map<String, String> keyMap, boolean isOnlyCheck) {
        if (filterModel != null && keyMap != null && !keyMap.isEmpty()) {
            Set entries = filterModel.entrySet();
            JSONObject obj = new JSONObject();
            for (Map.Entry entrie : entries) {
                if ("normal".equals(queryType) && !keyMap.containsKey(entrie.getKey())) {
                    log.warn("\u5b9e\u4f53\u6620\u5c04\u786e\u5c11\u5217\uff1a{}", entrie.getKey());
                    continue;
                }
                if (isOnlyCheck) {
                    obj.put((String)entrie.getKey(), entrie.getValue());
                    continue;
                }
                obj.put(keyMap.get(entrie.getKey()), entrie.getValue());
            }
            filterModel = obj;
        }
        return this.initFilerColumnInfo(filterModel, queryType);
    }

    public AgParm initFilerColumnInfo(JSONObject filterModel, String queryType, Map<String, String> keyMap) {
        return this.initFilerColumnInfo(filterModel, queryType, keyMap, false);
    }

    public AgParm initFilerColumnInfo(JSONObject filterModel, String queryType) {
        if (filterModel == null || filterModel.isEmpty()) {
            return null;
        }
        AgParm agParm = new AgParm();
        Set entries = filterModel.entrySet();
        StringBuffer sb = new StringBuffer(filterModel.size() * 20);
        StringBuffer sbReal = new StringBuffer(filterModel.size() * 20);
        HashMap<String, Object> parms = new HashMap<String, Object>();
        int count = 0;
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            JSONObject filter = (JSONObject)entry.getValue();
            String filterType = filter.getString("filterType");
            ColsReslover colsReslover = this.filterFunction.get(filterType);
            if ("date".equals(filterType) && !"normal".equals(queryType) && this.filterFunction.containsKey(filterType + "_" + queryType)) {
                colsReslover = this.filterFunction.getOrDefault(filterType + "_" + queryType, colsReslover);
            }
            if (!colsReslover.valid(filter)) continue;
            if (count > 0) {
                sb.append(" AND ");
                sbReal.append(" AND ");
            }
            String parmKey = colsReslover.getParmKey(key, filterType);
            if (filter.containsKey((Object)"operator")) {
                String operator = filter.getString("operator");
                JSONArray conditions = filter.getJSONArray("conditions");
                if (conditions.size() > 1) {
                    sb.append(" (");
                    sbReal.append(" (");
                }
                for (int i = 0; i < conditions.size(); ++i) {
                    Object parmValue2;
                    if (i > 0) {
                        sb.append(operator);
                        sbReal.append(operator);
                    }
                    JSONObject condition = conditions.getJSONObject(i);
                    colsReslover.appendKeySql(sb, agParm.getAliasName(), key, condition.getString("type"));
                    colsReslover.appendKeySql(sbReal, agParm.getAliasName(), key, condition.getString("type"));
                    String conditionSql = colsReslover.getConditionSql(condition.getString("type"));
                    String conditionSqlRel = colsReslover.getConditionSql(condition.getString("type"));
                    Object value = colsReslover.getParmValue(condition);
                    if (!"".equals(value) && value != null) {
                        parms.put(parmKey + i, value);
                        conditionSql = conditionSql.replaceFirst("Key", parmKey + i);
                        conditionSqlRel = conditionSqlRel.replaceFirst(":Key", colsReslover.getParmStringValue(condition));
                    }
                    if ((parmValue2 = colsReslover.getParmValue2(condition)) != null) {
                        conditionSql = conditionSql.replaceFirst("Key", parmKey + i + "_2");
                        parms.put(parmKey + i + "_2", parmValue2);
                        conditionSqlRel = conditionSqlRel.replaceFirst(":Key", colsReslover.getParmStringValue2(condition));
                    }
                    sb.append(conditionSql);
                    sbReal.append(conditionSqlRel);
                }
                if (conditions.size() > 1) {
                    sb.append(") ");
                    sbReal.append(") ");
                }
            } else {
                Object parmValue2;
                colsReslover.appendKeySql(sb, agParm.getAliasName(), key, filter.getString("type"));
                colsReslover.appendKeySql(sbReal, agParm.getAliasName(), key, filter.getString("type"));
                String conditionSql = colsReslover.getConditionSql(filter.getString("type"));
                String conditionSqlRel = colsReslover.getConditionSql(filter.getString("type"));
                Object value = colsReslover.getParmValue(filter);
                if (!"".equals(value) && value != null) {
                    parms.put(parmKey, value);
                    conditionSql = conditionSql.replaceFirst("Key", parmKey);
                    conditionSqlRel = conditionSqlRel.replaceFirst(":Key", colsReslover.getParmStringValue(filter));
                }
                if ((parmValue2 = colsReslover.getParmValue2(filter)) != null) {
                    conditionSql = conditionSql.replaceFirst("Key", parmKey + "_2");
                    parms.put(parmKey + "_2", parmValue2);
                    conditionSqlRel = conditionSqlRel.replaceFirst(":Key", colsReslover.getParmStringValue2(filter));
                }
                sb.append(conditionSql);
                sb.append(" ");
                sbReal.append(conditionSqlRel);
                sbReal.append(" ");
            }
            ++count;
        }
        agParm.setConditionSql(sb.toString());
        agParm.setConditionSqlRel(sbReal.toString());
        agParm.setValueParmsKeys(parms);
        agParm.setCount(count);
        return agParm;
    }

    public String initOrderColumnInfo(JSONArray sortModel, String queryType) {
        return this.initOrderColumnInfo(sortModel, queryType, null);
    }

    public String initOrderColumnInfo(JSONArray sortModel, String queryType, Map<String, String> keyMap) {
        return this.initOrderColumnInfo(sortModel, queryType, keyMap, false);
    }

    public String initOrderColumnInfo(JSONArray sortModel, String queryType, Map<String, String> keyMap, boolean isOnlyCheck) {
        if (sortModel == null || sortModel.isEmpty()) {
            return null;
        }
        StringBuffer order = new StringBuffer(sortModel.size() * 20);
        int count = 0;
        for (int i = 0; i < sortModel.size(); ++i) {
            JSONObject sort = sortModel.getJSONObject(i);
            String colId = sort.getString("colId");
            if (keyMap != null) {
                if ("normal".equals(queryType) && !keyMap.containsKey(colId)) {
                    log.warn("\u5b9e\u4f53\u6620\u5c04\u786e\u5c11\u5217\uff1a{}", (Object)colId);
                    continue;
                }
                if (!isOnlyCheck) {
                    colId = keyMap.get(colId);
                }
            }
            if (count > 0) {
                order.append(",");
            }
            order.append(" ");
            order.append(colId);
            order.append(" ");
            order.append(sort.getString("sort"));
            order.append(" ");
            ++count;
        }
        return order.toString();
    }

    class NumberReslover
    implements ColsReslover {
        NumberReslover() {
        }

        @Override
        public boolean valid(JSONObject filter) {
            return filter.containsKey((Object)"filter") || filter.containsKey((Object)"conditions");
        }

        @Override
        public Object getParmValue(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"number".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in NumberReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getBigDecimal("filter");
        }

        @Override
        public String getParmStringValue(JSONObject filter) {
            return filter.getBigDecimal("filter").toString();
        }

        @Override
        public Object getParmValue2(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"number".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in NumberReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getBigDecimal("filterTo");
        }

        @Override
        public String getParmStringValue2(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"number".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in NumberReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getBigDecimal("filterTo").toString();
        }

        @Override
        public String getConditionSql(String type) {
            return AgGridReslover.this.numberConditionSqlTemp.getOrDefault(type, " > :Key ");
        }
    }

    class SqlDateReslover
    extends DateReslover {
        SqlDateReslover() {
        }

        @Override
        public StringBuffer appendKeySql(StringBuffer sb, String aliasName, String key, String type) {
            boolean isNeed;
            sb.append(" ");
            boolean bl = isNeed = "equals".equals(type) || "notEqual".equals(type);
            if (isNeed) {
                sb.append("date(");
            }
            sb.append(aliasName);
            sb.append(key);
            if (isNeed) {
                sb.append(")");
            }
            sb.append(" ");
            return sb;
        }
    }

    class DateReslover
    implements ColsReslover {
        DateReslover() {
        }

        @Override
        public boolean valid(JSONObject filter) {
            return filter.containsKey((Object)"dateFrom") || filter.containsKey((Object)"conditions");
        }

        @Override
        public Object getParmValue(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"date".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in DateReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getDate("dateFrom");
        }

        @Override
        public String getParmStringValue(JSONObject filter) {
            return "'" + DateUtils.dateTimeToString(filter.getDate("dateFrom")) + "'";
        }

        @Override
        public Object getParmValue2(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"date".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in DateReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getDate("dateTo");
        }

        @Override
        public String getParmStringValue2(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"date".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in DateReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return "'" + DateUtils.dateTimeToString(filter.getDate("dateTo")) + "'";
        }

        @Override
        public String getConditionSql(String type) {
            return AgGridReslover.this.timeConditionSqlTemp.getOrDefault(type, " > :Key ");
        }

        @Override
        public StringBuffer appendKeySql(StringBuffer sb, String aliasName, String key, String type) {
            boolean isNeed;
            sb.append(" ");
            boolean bl = isNeed = "equals".equals(type) || "notEqual".equals(type);
            if (isNeed) {
                sb.append("FUNCTION('date',");
            }
            sb.append(aliasName);
            sb.append(key);
            if (isNeed) {
                sb.append(")");
            }
            sb.append(" ");
            return sb;
        }
    }

    class TextReslover
    implements ColsReslover {
        TextReslover() {
        }

        @Override
        public boolean valid(JSONObject filter) {
            return filter.containsKey((Object)"filter") || filter.containsKey((Object)"conditions");
        }

        @Override
        public Object getParmValue(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"text".equals(filterType)) {
                log.error("filterType [{}] is UnsupportedDataTypeException in TextReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            String val = AgGridReslover.this.valTemp.getOrDefault(filter.getString("type"), "");
            return val.replace("Val", filter.getString("filter"));
        }

        @Override
        public String getParmStringValue(JSONObject filter) {
            String val = AgGridReslover.this.valTemp.getOrDefault(filter.getString("type"), "");
            return "'" + val.replace("Val", filter.getString("filter")) + "'";
        }

        @Override
        public String getConditionSql(String type) {
            return AgGridReslover.this.conditionSqlTemp.getOrDefault(type, " = :Key ");
        }
    }

    class SetReslover
    implements ColsReslover {
        SetReslover() {
        }

        @Override
        public boolean valid(JSONObject filter) {
            return StrUtil.listIsNotNull(filter.getJSONArray("values"));
        }

        @Override
        public Object getParmValue(JSONObject filter) {
            String filterType = filter.getString("filterType");
            if (!"set".equals(filterType)) {
                log.error("filterType [{}] is IllegalArgumentException in SetReslover.", (Object)filterType);
                throw new IllegalArgumentException("\u53c2\u6570\u9519\u8bef");
            }
            return filter.getJSONArray("values");
        }

        @Override
        public String getParmStringValue(JSONObject filter) {
            String jsonString = filter.getJSONArray("values").toJSONString();
            return "(" + jsonString.substring(1, jsonString.length() - 1) + ")";
        }

        @Override
        public String getConditionSql(String type) {
            return " in (:Key)";
        }
    }

    static interface ColsReslover {
        public boolean valid(JSONObject var1);

        default public String getParmKey(String key, String filterType) {
            return String.format("%s_%s_ag", filterType, key);
        }

        public Object getParmValue(JSONObject var1);

        public String getParmStringValue(JSONObject var1);

        default public Object getParmValue2(JSONObject filter) {
            return null;
        }

        default public String getParmStringValue2(JSONObject filter) {
            return null;
        }

        public String getConditionSql(String var1);

        default public StringBuffer appendKeySql(StringBuffer sb, String aliasName, String key, String type) {
            sb.append(" ");
            sb.append(aliasName);
            sb.append(key);
            sb.append(" ");
            return sb;
        }
    }
}

