/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BeanFactoryUtil
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(BeanFactoryUtil.class);
    private static volatile ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        applicationContext = context;
        log.info("holded applicationContext,displayName:" + applicationContext.getDisplayName());
        log.info("xpmplus platform version is 3.0");
    }

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("BeanFactoryUtil not holded 'applicationContext' !");
        }
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initApplicationContext(String ... xmlPath) {
        if (applicationContext != null) return;
        log.info("test unit begin init 'applicationContext'.");
        Class<BeanFactoryUtil> clazz = BeanFactoryUtil.class;
        synchronized (BeanFactoryUtil.class) {
            if (applicationContext != null) return;
            new ClassPathXmlApplicationContext(xmlPath);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> baseType) {
        return BeanFactoryUtil.getApplicationContext().getBeansOfType(baseType);
    }

    public static <T> T getBean(Class<T> c) {
        return (T)BeanFactoryUtil.getApplicationContext().getBean(c);
    }

    public static Object getBean(String beanName) {
        return BeanFactoryUtil.getApplicationContext().getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        return (T)BeanFactoryUtil.getApplicationContext().getBean(beanName, requiredType);
    }

    public static boolean containsBean(String beanName) {
        return BeanFactoryUtil.getApplicationContext().containsBean(beanName);
    }
}

