/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.component.context.impl;

import com.kotelmems.platform.component.context.IContext;
import com.kotelmems.platform.component.context.IContextManager;
import com.kotelmems.platform.component.context.impl.IContextImpl;

public class IContextManagerImpl
implements IContextManager {
    private static final ThreadLocal<IContext> container = new ThreadLocal();

    @Override
    public IContext getContext() {
        IContext context = container.get();
        if (null == context) {
            container.set(new IContextImpl());
        }
        return container.get();
    }

    @Override
    public boolean removeContext() {
        IContext context = container.get();
        if (context == null) {
            return false;
        }
        context.clear();
        container.remove();
        return true;
    }

    @Override
    public void putContextValue(Object index, Object obj) {
        IContext context = this.getContext();
        context.put(index, obj);
    }

    @Override
    public Object getContextValue(Object index) {
        IContext context = this.getContext();
        return context.get(index);
    }

    @Override
    public boolean removeContextValue(Object index) {
        IContext context = this.getContext();
        if (context == null) {
            return false;
        }
        context.remove(index);
        return true;
    }
}

