/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.jdbc.sql;

import com.jumipm.common.utils.PasswordPolicyUtil;
import com.jumipm.utils.CryptHelper;
import com.jumipm.utils.StrUtil;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JdbcSqlConnection {
    private static Log log = LogFactory.getLog(JdbcSqlConnection.class);

    public static Connection getConn() throws SQLException, InstantiationException, IllegalAccessException, ClassNotFoundException, IOException {
        Properties prop = new Properties();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties");
        prop.load(in);
        String driverClassName = prop.getProperty("jdbc.driverClassName");
        String url = prop.getProperty("jdbc.url");
        String username = prop.getProperty("jdbc.username");
        String password = prop.getProperty("jdbc.password");
        password = JdbcSqlConnection.getPasswordDecrypt(password);
        Class.forName(driverClassName).newInstance();
        Connection conn = null;
        conn = username == null || "".equals(username) ? DriverManager.getConnection(url) : DriverManager.getConnection(url, username, password);
        return conn;
    }

    public static String getPasswordDecrypt(String pssswd) {
        try {
            if (StrUtil.isNull(pssswd) || pssswd.length() < 30) {
                return pssswd;
            }
            return CryptHelper.decrypt("AES", 128, pssswd, "UTF-8", new PasswordPolicyUtil().getSecretkey());
        }
        catch (Exception e) {
            log.info((Object)e.getMessage());
            return pssswd;
        }
    }

    public static ArrayList resultSetToListMap(ResultSet rs) throws Exception {
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList list = new ArrayList();
        while (rs.next()) {
            HashMap<String, Object> rowData = new HashMap<String, Object>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Object v = rs.getObject(i);
                if (v != null && (v.getClass() == java.util.Date.class || v.getClass() == Date.class)) {
                    Timestamp ts = rs.getTimestamp(i);
                    v = new java.util.Date(ts.getTime());
                }
                rowData.put(md.getColumnName(i), v);
            }
            list.add(rowData);
        }
        return list;
    }

    public static List<String> resultSetToListString(ResultSet rs) throws Exception {
        ResultSetMetaData md = rs.getMetaData();
        int columnCount = md.getColumnCount();
        ArrayList<String> list = new ArrayList<String>();
        String value = "";
        while (rs.next()) {
            for (int i = 1; i <= columnCount; ++i) {
                value = rs.getObject(i).toString();
            }
            list.add(value);
        }
        return list;
    }
}

