/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.page;

import com.alibaba.fastjson.JSONObject;
import com.kotelmems.platform.page.AgParm;
import com.kotelmems.platform.page.PageUtils;
import com.kotelmems.platform.page.SortInfo;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public class PageRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int pageNumber = 1;
    private int pageSize = 0;
    private String sortColumns;
    private String sSearch;
    private JSONObject agGridParam;
    private AgParm agParm;

    public AgParm getAgParm() {
        return this.agParm;
    }

    public void setAgParm(AgParm agParm) {
        this.agParm = agParm;
    }

    public PageRequest() {
    }

    public PageRequest(int pageNumber, int pageSize) {
        this(pageNumber, pageSize, null);
    }

    public PageRequest(int pageNumber, int pageSize, String sortColumns) {
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.setSortColumns(sortColumns);
    }

    public int getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public String getSortColumns() {
        return this.sortColumns;
    }

    public int getFirstResult() {
        int firstResult = PageUtils.getFirstResult(this.pageNumber, this.pageSize);
        return firstResult < 0 ? 0 : firstResult;
    }

    public void setSortColumns(String sortColumns) {
        this.checkSortColumnsSqlInjection(sortColumns);
        if (sortColumns != null && sortColumns.length() > 50) {
            throw new IllegalArgumentException("sortColumns.length() <= 50 must be true");
        }
        this.sortColumns = sortColumns;
    }

    public List<SortInfo> getSortInfos() {
        return Collections.unmodifiableList(SortInfo.parseSortColumns(this.sortColumns));
    }

    public void setFirstResult(int first) {
    }

    public void setSortInfos(List<SortInfo> sorts) {
    }

    private void checkSortColumnsSqlInjection(String sortColumns) {
        if (sortColumns == null) {
            return;
        }
        if (sortColumns.indexOf("'") >= 0 || sortColumns.indexOf("\\") >= 0) {
            throw new IllegalArgumentException("sortColumns:" + sortColumns + " has SQL Injection risk");
        }
    }

    public String getsSearch() {
        return this.sSearch;
    }

    public void setsSearch(String sSearch) {
        this.sSearch = sSearch;
    }

    public JSONObject getAgGridParam() {
        return this.agGridParam;
    }

    public void setAgGridParam(JSONObject agGridParam) {
        this.agGridParam = agGridParam;
    }

    public String toString() {
        return "PageRequest(pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", sortColumns=" + this.getSortColumns() + ", sSearch=" + this.getsSearch() + ", agGridParam=" + this.getAgGridParam() + ", agParm=" + this.getAgParm() + ")";
    }
}

