/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;

public class DateConvertUtils {
    public static String FORMAT_DATE = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    public static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.S";

    public static Date parse(String dateString, String dateFormat) {
        return DateConvertUtils.parse(dateString, dateFormat, Date.class);
    }

    public static <T extends Date> T parse(String dateString, String dateFormat, Class<T> targetResultType) {
        if (StringUtils.isEmpty((CharSequence)dateString)) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat(dateFormat);
        try {
            long time = df.parse(dateString).getTime();
            Date t = (Date)targetResultType.getConstructor(Long.TYPE).newInstance(time);
            return (T)t;
        }
        catch (ParseException e) {
            String errorInfo = "cannot use dateformat:" + dateFormat + " parse datestring:" + dateString;
            throw new IllegalArgumentException(errorInfo, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("error targetResultType:" + targetResultType.getName(), e);
        }
    }

    public static String format(Date date, String dateFormat) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat(dateFormat).format(date);
    }

    public static SimpleDateFormat getSimpleDateFormat(int type, String ... tax) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat();
        if (null == tax || tax.length == 0) {
            tax = new String[]{"-"};
        }
        switch (type) {
            case 1: {
                simpleDateFormat.applyPattern("yyyy" + tax[0] + "MM" + tax[0] + "dd HH:mm:ss");
                break;
            }
            case 2: {
                simpleDateFormat.applyPattern("yyyy" + tax[0] + "MM" + tax[0] + "dd");
                break;
            }
            case 3: {
                simpleDateFormat.applyPattern("yyyy" + tax[0] + "MM");
                break;
            }
            case 4: {
                simpleDateFormat.applyPattern(TIME_FORMAT);
                break;
            }
            case 5: {
                simpleDateFormat.applyPattern("HH:mm");
                break;
            }
            case 6: {
                simpleDateFormat.applyPattern("yyyy" + tax[0] + "MM" + tax[0] + "dd HH:mm");
                break;
            }
            case 7: {
                simpleDateFormat.applyPattern("yyyy\u5e74MM\u6708");
                break;
            }
            default: {
                simpleDateFormat.applyPattern("yyyy" + tax[0] + "MM" + tax[0] + "dd HH:mm:ss");
            }
        }
        return simpleDateFormat;
    }

    private static Calendar getcalendar(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int getDayOfMonth(Date date) {
        Calendar calendar = DateConvertUtils.getcalendar(date);
        return calendar.getActualMaximum(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar calendar = DateConvertUtils.getcalendar(date);
        calendar.set(5, calendar.get(5) - 1);
        return calendar.get(7);
    }
}

