/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.dao.hibernate;

import com.alibaba.fastjson.JSONObject;
import com.jumipm.common.exception.BusinessException;
import com.jumipm.license.service.VerifyLicense;
import com.jumipm.utils.StrUtil;
import com.kotelmems.platform.dao.BaseDaoTableColumn;
import com.kotelmems.platform.dao.BaseDaoTableParm;
import com.kotelmems.platform.dao.EntityDao;
import com.kotelmems.platform.page.AgParm;
import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.page.PageUtils;
import com.kotelmems.platform.util.PageQueryUtils;
import com.kotelmems.platform.vo.DaoCustomParm;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import javax.transaction.NotSupportedException;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.query.NativeQuery;
import org.hibernate.transform.ResultTransformer;
import org.hibernate.transform.Transformers;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.hibernate5.support.HibernateDaoSupport;
import org.springframework.util.CollectionUtils;

public abstract class BaseHibernateDao<E, PK extends Serializable>
extends HibernateDaoSupport
implements EntityDao<E, PK> {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @Resource
    private VerifyLicense verifyLicense;

    public long queryForLong(String queryString) {
        return this.queryForLong(queryString, new Object[0]);
    }

    public long queryForLong(String queryString, Object value) {
        return this.queryForLong(queryString, new Object[]{value});
    }

    public long queryForLong(String queryString, Object[] values) {
        return DataAccessUtils.longResult((Collection)this.getHibernateTemplate().find(queryString, values));
    }

    public abstract Class<E> getEntityClass();

    protected void prepareObjectForInsert(E o) {
    }

    protected void prepareObjectForUpdate(E o) {
    }

    @Override
    public E getById(PK id) {
        return (E)this.getHibernateTemplate().get(this.getEntityClass(), id);
    }

    @Override
    public E insert(E entity) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        this.prepareObjectForInsert(entity);
        Serializable id = this.getHibernateTemplate().save(entity);
        return this.getById(id);
    }

    public void delete(Object entity) {
        if (!this.verifyLicense.licInfoVerify()) {
            return;
        }
        this.getHibernateTemplate().delete(entity);
    }

    public void deleteAllByParameter(E parameter) {
        List list;
        if (!this.verifyLicense.licInfoVerify()) {
            return;
        }
        if (null != parameter && (list = this.findAllByParam(parameter)).size() > 0) {
            this.getHibernateTemplate().deleteAll((Collection)list);
        }
    }

    private boolean checkThowInParmException(Object[] inParm) {
        if (inParm == null || inParm.length == 0) {
            this.log.warn("in\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u96c6\u5408\uff01");
            throw new NullPointerException("in\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u6216\u7a7a\u96c6\u5408\uff01");
        }
        return false;
    }

    public int updateByMapParm(Map<String, Object> mapVal, Map<String, Object> mapParm, Map<String, Object[]> inmap) {
        return this.updateByMapParm(mapVal, mapParm, null, null, inmap, null);
    }

    public int updateByMapParm(Map<String, Object> mapVal, Map<String, Object> mapParm, Map<String, Object> notMap, Map<String, Object[]> inmap) {
        return this.updateByMapParm(mapVal, mapParm, notMap, null, inmap, null);
    }

    public int updateByMapParm(final Map<String, Object> mapVal, final Map<String, Object> mapParm, final Map<String, Object> notMap, final Map<String, Date> dateParm, final Map<String, Object[]> inmap, final Map<String, Object[]> notInmap) {
        Iterator<Map.Entry<String, Object[]>> iteratorInmap;
        Iterator<Map.Entry<String, Object[]>> notInmapiterator;
        Iterator<Map.Entry<String, Object>> notMapiterator;
        Iterator<Map.Entry<String, Object>> iteratorParm;
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" UPDATE ").append(this.getEntityClass().getSimpleName());
        sb.append(" s ");
        Iterator<Map.Entry<String, Object>> iterator = mapVal == null ? null : mapVal.entrySet().iterator();
        int count = 0;
        while (null != iterator && iterator.hasNext()) {
            if (count > 0) {
                sb.append(", s.");
            } else {
                sb.append(" SET s.");
            }
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(entry.getKey());
            sb.append(" = :");
            sb.append(entry.getKey());
            ++count;
        }
        if (count == 0) {
            this.log.warn("\u65e0\u6709\u6548\u66f4\u65b0\u5185\u5bb9\u76f4\u63a5\u8fd4\u56de\u7ed3\u675f>>>>");
            return 0;
        }
        sb.append(" WHERE 1=1 ");
        Iterator<Map.Entry<String, Date>> dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
        int datecount = 0;
        while (null != dateParmiterator && dateParmiterator.hasNext()) {
            Map.Entry<String, Date> entry = dateParmiterator.next();
            if (null == entry.getValue()) continue;
            sb.append(" AND ");
            sb.append(entry.getKey().replaceAll("&&", " "));
            sb.append(" :date_");
            sb.append(datecount);
            ++datecount;
        }
        Iterator<Map.Entry<String, Object>> iterator2 = iteratorParm = mapParm == null ? null : mapParm.entrySet().iterator();
        while (null != iteratorParm && iteratorParm.hasNext()) {
            Map.Entry<String, Object> entry = iteratorParm.next();
            sb.append(" AND s.");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
                continue;
            }
            sb.append(" = :p_");
            sb.append(entry.getKey());
        }
        Iterator<Map.Entry<String, Object>> iterator3 = notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
        while (null != notMapiterator && notMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = notMapiterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NOT NULL ");
                continue;
            }
            sb.append(" <> :not_");
            sb.append(entry.getKey());
        }
        Iterator<Map.Entry<String, Object[]>> iterator4 = notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
        while (null != notInmapiterator && notInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = notInmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            sb.append(" AND ");
            sb.append(entry.getKey());
            sb.append(" NOT IN (:noti_");
            sb.append(entry.getKey());
            sb.append(")");
        }
        Iterator<Map.Entry<String, Object[]>> iterator5 = iteratorInmap = inmap == null ? null : inmap.entrySet().iterator();
        while (null != iteratorInmap && iteratorInmap.hasNext()) {
            Map.Entry<String, Object[]> entry = iteratorInmap.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            sb.append(" AND s.");
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator notInmapiterator;
                Iterator notMapiterator;
                Iterator iteratorInmap;
                Iterator iteratorParm;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = mapVal == null ? null : mapVal.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iterator3 = iteratorParm = mapParm == null ? null : mapParm.entrySet().iterator();
                while (null != iteratorParm && iteratorParm.hasNext()) {
                    Map.Entry entry = iteratorParm.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("p_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator4 = iteratorInmap = inmap == null ? null : inmap.entrySet().iterator();
                while (null != iteratorInmap && iteratorInmap.hasNext()) {
                    Map.Entry entry = iteratorInmap.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator iterator5 = notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
                while (null != notMapiterator && notMapiterator.hasNext()) {
                    Map.Entry entry = notMapiterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator6 = notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
                while (null != notInmapiterator && notInmapiterator.hasNext()) {
                    Map.Entry entry = notInmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
                int datecount = 0;
                while (null != dateParmiterator && dateParmiterator.hasNext()) {
                    Map.Entry entry = dateParmiterator.next();
                    if (null != entry.getValue()) {
                        query.setParameter("date_" + datecount, entry.getValue(), (Type)StandardBasicTypes.DATE);
                    }
                    ++datecount;
                }
                return query.executeUpdate();
            }
        });
    }

    public E findFirstByMapParm(Map<String, Object> map) {
        List<E> allByMapParm = this.findAllByMapParm(map, null, null);
        if (StrUtil.listIsNull(allByMapParm)) {
            return null;
        }
        return allByMapParm.get(0);
    }

    public E findFirstByMapParm(Map<String, Object> map, Map<String, Object[]> inmap) {
        List<E> allByMapParm = this.findAllByMapParm(map, inmap, null);
        if (StrUtil.listIsNull(allByMapParm)) {
            return null;
        }
        return allByMapParm.get(0);
    }

    public List<E> findAllByMapParm(Map<String, Object> map, Map<String, Object[]> inmap) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        return this.findAllByMapParm(map, inmap, null);
    }

    public List<E> findAllByMapParmLike(Map<String, Object> map, Map<String, Object[]> inmap, Map<String, String> likeparm) {
        return this.findAllByMapParm(map, inmap, null, null, likeparm, null);
    }

    public List<E> findAllByMapParm(Map<String, Object> map, Map<String, Object[]> inmap, String order) {
        return this.findAllByMapParm(map, inmap, null, order);
    }

    public List<E> findAllByMapParm(Map<String, Object> map, Map<String, Object[]> inmap, Map<String, Date> dateParm, String order) {
        return this.findAllByMapParm(map, inmap, dateParm, null, null, order);
    }

    public List<E> findAllByMapParm(Map<String, Object> map, Map<String, Object[]> inmap, Map<String, Date> dateParm, Map<String, BigDecimal> decimalParm, String order) {
        return this.findAllByMapParm(map, inmap, dateParm, decimalParm, null, order);
    }

    public List<E> findAllByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap, final Map<String, Date> dateParm, final Map<String, BigDecimal> decimalParm, final Map<String, String> likeParm, String order) {
        Iterator<Map.Entry<String, Object[]>> inmapiterator;
        Iterator<Map.Entry<String, Object>> iterator;
        Iterator<Map.Entry<String, BigDecimal>> decimalParmiterator;
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        int count = 0;
        Iterator<Map.Entry<String, Date>> dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
        int datecount = 0;
        while (null != dateParmiterator && dateParmiterator.hasNext()) {
            Map.Entry<String, Date> entry = dateParmiterator.next();
            if (null == entry.getValue()) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey().replaceAll("&&", " "));
            sb.append(" :date_");
            sb.append(datecount);
            ++datecount;
            ++count;
        }
        int decimalcount = 0;
        Iterator<Map.Entry<String, BigDecimal>> iterator2 = decimalParmiterator = decimalParm == null ? null : decimalParm.entrySet().iterator();
        while (null != decimalParmiterator && decimalParmiterator.hasNext()) {
            Map.Entry<String, BigDecimal> entry = decimalParmiterator.next();
            if (null == entry.getValue()) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey().replaceAll("&&", " "));
            sb.append(" :decimal_");
            sb.append(decimalcount);
            ++decimalcount;
            ++count;
        }
        Iterator<Map.Entry<String, Object>> iterator3 = iterator = map == null ? null : map.entrySet().iterator();
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator4 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (null != inmapiterator && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (likeParm != null && !likeParm.isEmpty()) {
            if (count > 0) {
                sb.append(" AND ");
            }
            sb.append(" ( ");
            Iterator<Map.Entry<String, String>> likeiterator = likeParm.entrySet().iterator();
            int likecount = 0;
            while (null != likeiterator && likeiterator.hasNext()) {
                Map.Entry<String, String> entry = likeiterator.next();
                if (!StringUtils.isNotEmpty((CharSequence)entry.getValue())) continue;
                if (likecount > 0) {
                    sb.append(" OR ");
                }
                sb.append(entry.getKey());
                sb.append(" LIKE ");
                sb.append(" :like_");
                sb.append(entry.getKey());
                ++count;
                ++likecount;
            }
            sb.append(" ) ");
        }
        if (count == 0) {
            return new ArrayList();
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator inmapiterator;
                Iterator likeiterator;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = map == null ? null : map.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iterator3 = likeiterator = likeParm == null ? null : likeParm.entrySet().iterator();
                while (null != likeiterator && likeiterator.hasNext()) {
                    Map.Entry entry = likeiterator.next();
                    if (!StringUtils.isNotEmpty((CharSequence)((CharSequence)entry.getValue()))) continue;
                    query.setParameter("like_" + (String)entry.getKey(), (Object)("%" + (String)entry.getValue() + "%"));
                }
                Iterator iterator4 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (null != inmapiterator && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
                int datecount = 0;
                while (null != dateParmiterator && dateParmiterator.hasNext()) {
                    Map.Entry entry = dateParmiterator.next();
                    if (null != entry.getValue()) {
                        query.setParameter("date_" + datecount, entry.getValue(), (Type)StandardBasicTypes.DATE);
                    }
                    ++datecount;
                }
                Iterator decimalParmiterator = decimalParm == null ? null : decimalParm.entrySet().iterator();
                int decimalcount = 0;
                while (null != decimalParmiterator && decimalParmiterator.hasNext()) {
                    Map.Entry entry = decimalParmiterator.next();
                    if (null != entry.getValue()) {
                        query.setParameter("decimal_" + decimalcount, entry.getValue(), (Type)StandardBasicTypes.BIG_DECIMAL);
                    }
                    ++decimalcount;
                }
                return query.list();
            }
        });
    }

    public List findAllByMapNotOrParm(Map<String, Object> map, Map<String, Object> notMap, Map<String, Object[]> inmap, Map<String, Object[]> notInmap, Map<String, Object> orMap, Map<String, Object> orNotMap, Map<String, Object[]> orInmap, Map<String, Object[]> orNotInmap, String columns) {
        return this.findAllByMapNotOrParm(map, notMap, inmap, notInmap, orMap, orNotMap, orInmap, orNotInmap, columns, null);
    }

    public List findAllByMapNotOrParm(final Map<String, Object> map, final Map<String, Object> notMap, final Map<String, Object[]> inmap, final Map<String, Object[]> notInmap, final Map<String, Object> orMap, final Map<String, Object> orNotMap, final Map<String, Object[]> orInmap, final Map<String, Object[]> orNotInmap, final String columns, String order) {
        Iterator<Map.Entry<String, Object[]>> orNotInmapiterator;
        Iterator<Map.Entry<String, Object[]>> orInmapiterator;
        Iterator<Map.Entry<String, Object>> orNotMapiterator;
        Iterator<Map.Entry<String, Object>> orMapiterator;
        Iterator<Map.Entry<String, Object[]>> notInmapiterator;
        Iterator<Map.Entry<String, Object[]>> inmapiterator;
        Iterator<Map.Entry<String, Object>> notMapiterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(200);
        int columnCount = 0;
        if (!BaseHibernateDao.isEmpty(columns)) {
            sb.append(" SELECT ");
            String[] arry = columns.split(",");
            columnCount = arry.length;
            for (int i = 0; i < columnCount; ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(arry[i]);
                sb.append(" AS ");
                sb.append(arry[i]);
            }
        }
        final int findColumnCount = columnCount;
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object>> iterator2 = notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
        while (null != notMapiterator && notMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = notMapiterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :not_");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator3 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (null != inmapiterator && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator4 = notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
        while (null != notInmapiterator && notInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = notInmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" NOT IN (:noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        int orcount = 0;
        Iterator<Map.Entry<String, Object>> iterator5 = orMapiterator = orMap == null ? null : orMap.entrySet().iterator();
        while (null != orMapiterator && orMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = orMapiterator.next();
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :or_");
                sb.append(entry.getKey());
            }
            ++orcount;
        }
        Iterator<Map.Entry<String, Object>> iterator6 = orNotMapiterator = orNotMap == null ? null : orNotMap.entrySet().iterator();
        while (null != orNotMapiterator && orNotMapiterator.hasNext()) {
            Map.Entry<String, Object> entry = orNotMapiterator.next();
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :orNot_");
                sb.append(entry.getKey());
            }
            ++orcount;
        }
        Iterator<Map.Entry<String, Object[]>> iterator7 = orInmapiterator = orInmap == null ? null : orInmap.entrySet().iterator();
        while (null != orInmapiterator && orInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = orInmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:or_i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++orcount;
        }
        Iterator<Map.Entry<String, Object[]>> iterator8 = orNotInmapiterator = orNotInmap == null ? null : orNotInmap.entrySet().iterator();
        while (null != orNotInmapiterator && orNotInmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = orNotInmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count > 0 && orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            sb.append(" NOT IN (:or_noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++orcount;
        }
        if (count > 0 && orcount > 0) {
            sb.append(" ) ");
        }
        if (count + orcount == 0) {
            return new ArrayList();
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator orNotInmapiterator;
                Iterator orinmapiterator;
                Iterator orNotMapiterator;
                Iterator oriterator;
                Iterator notInmapiterator;
                Iterator inmapiterator;
                Iterator notMapiterator;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = map == null ? null : map.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iterator3 = notMapiterator = notMap == null ? null : notMap.entrySet().iterator();
                while (null != notMapiterator && notMapiterator.hasNext()) {
                    Map.Entry entry = notMapiterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator4 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (null != inmapiterator && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator iterator5 = notInmapiterator = notInmap == null ? null : notInmap.entrySet().iterator();
                while (null != notInmapiterator && notInmapiterator.hasNext()) {
                    Map.Entry entry = notInmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator iterator6 = oriterator = orMap == null ? null : orMap.entrySet().iterator();
                while (null != oriterator && oriterator.hasNext()) {
                    Map.Entry entry = oriterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("or_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator7 = orNotMapiterator = orNotMap == null ? null : orNotMap.entrySet().iterator();
                while (null != orNotMapiterator && orNotMapiterator.hasNext()) {
                    Map.Entry entry = orNotMapiterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("orNot_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator8 = orinmapiterator = orInmap == null ? null : orInmap.entrySet().iterator();
                while (null != orinmapiterator && orinmapiterator.hasNext()) {
                    Map.Entry entry = orinmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("or_i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator iterator9 = orNotInmapiterator = orNotInmap == null ? null : orNotInmap.entrySet().iterator();
                while (null != orNotInmapiterator && orNotInmapiterator.hasNext()) {
                    Map.Entry entry = orNotInmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("or_noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                if (!BaseHibernateDao.isEmpty(columns) && findColumnCount != 1) {
                    query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                }
                return query.list();
            }
        });
    }

    public List findAllByMapOrParm(Map<String, Object> map, Map<String, Object[]> inmap, Map<String, Object[]> notInmap, Map<String, Object> orMap, Map<String, Object[]> orInmap, Map<String, Object[]> orNotInmap, String columns) {
        return this.findAllByMapNotOrParm(map, null, inmap, notInmap, orMap, null, orInmap, orNotInmap, columns);
    }

    public List<Map<String, Object>> findColumnsByMapParm(Map<String, Object> map, Map<String, Object[]> inmap, String columns) {
        return this.findColumnsByMapParm(map, inmap, columns, null);
    }

    public List<Map<String, Object>> findColumnsByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap, String columns, String order) {
        Iterator<Map.Entry<String, Object[]>> inmapiterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        for (int i = 0; i < arry.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator2 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (null != inmapiterator && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator inmapiterator;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = map == null ? null : map.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iterator3 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (null != inmapiterator && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public Integer findCountByMapParm(final Map<String, Object> map, final Map<String, Object[]> inmap) {
        Iterator<Map.Entry<String, Object[]>> inmapiterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        Iterator<Map.Entry<String, Object>> iterator = map == null ? null : map.entrySet().iterator();
        int count = 0;
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator2 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (null != inmapiterator && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            if (count != 0) {
                sb.append(" AND ");
            }
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator inmapiterator;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = map == null ? null : map.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator iterator3 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (null != inmapiterator && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Object b = query.uniqueResult();
                if (null == b) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public E findFirstByFK(String key, Object value) {
        List<E> list = this.findAllByFK(key, value, null);
        return CollectionUtils.isEmpty(list) ? null : (E)list.get(0);
    }

    public E findFirstByFK(String key, Object value, String order) {
        List<E> list = this.findAllByFK(key, value, order);
        return CollectionUtils.isEmpty(list) ? null : (E)list.get(0);
    }

    public List<E> findAllByFK(String key, Object value) {
        return this.findAllByFK(key, value, null);
    }

    public String appendSortSql(PageRequest pageRequest, String order) {
        if (pageRequest != null && StringUtils.isNotEmpty((CharSequence)pageRequest.getSortColumns())) {
            return this.appendSortSql(pageRequest.getSortColumns());
        }
        return this.appendSortSql(order);
    }

    public String appendSortSql(String order) {
        if (StringUtils.isNotEmpty((CharSequence)order)) {
            return " ORDER BY " + order;
        }
        String defaultSortColumn = this.getDefaultSortColumn();
        if (StringUtils.isNotEmpty((CharSequence)defaultSortColumn)) {
            return " ORDER BY " + defaultSortColumn;
        }
        return "";
    }

    public List<E> findAllByFK(String key, final Object value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                return query.list();
            }
        });
    }

    public List<E> findAllNotByFK(String key, Object value) {
        return this.findAllNotByFK(key, value, null);
    }

    public List<E> findAllNotByFK(String key, final Object value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsByFK(String key, Object value, String columns) {
        return this.findColumnsByFK(key, value, columns, null);
    }

    public List<Map<String, Object>> findColumnsByFK(String key, final Object value, String columns, String order) {
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        for (int i = 0; i < arry.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsNotByFK(String key, Object value, String columns) {
        return this.findColumnsNotByFK(key, value, columns, null);
    }

    public List<Map<String, Object>> findColumnsNotByFK(String key, final Object value, String columns, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        for (int i = 0; i < arry.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public Integer findCountByFK(String key, final Object value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object b;
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                if (null == (b = query.uniqueResult())) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountNotByFK(String key, final Object value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Object b;
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                if (null == (b = query.uniqueResult())) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountInArry(String key, final Object[] value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                Object b = query.uniqueResult();
                if (null == b) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public Integer findCountNotInArry(String key, final Object[] value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        this.checkThowInParmException(value);
        StringBuffer sb = new StringBuffer(" SELECT COUNT(*) FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                Object b = query.uniqueResult();
                if (null == b) {
                    b = 0;
                }
                return new Integer(b.toString());
            }
        });
    }

    public List<Map<String, Object>> findColumnsInArry(String key, Object[] value, String columns) {
        return this.findColumnsInArry(key, value, columns, null);
    }

    public List<Map<String, Object>> findColumnsInArry(String key, final Object[] value, String columns, String order) {
        if (this.checkThowInParmException(value)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        for (int i = 0; i < arry.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<Map<String, Object>> findColumnsNotInArry(String key, Object[] value, String columns) {
        return this.findColumnsNotInArry(key, value, columns, null);
    }

    public List<Map<String, Object>> findColumnsNotInArry(String key, final Object[] value, String columns, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (this.checkThowInParmException(value)) {
            return new ArrayList<Map<String, Object>>();
        }
        if (BaseHibernateDao.isEmpty(columns)) {
            throw new NullPointerException("\u6307\u5b9a\u5217\u5185\u5bb9\u4e3a\u7a7a");
        }
        StringBuffer sb = new StringBuffer(" SELECT ");
        String[] arry = columns.split(",");
        for (int i = 0; i < arry.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(arry[i]);
            sb.append(" AS ");
            sb.append(arry[i]);
        }
        sb.append(" FROM ");
        sb.append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                return query.list();
            }
        });
    }

    public List<E> findAllKeyInArry(String key, Object[] value) {
        return this.findAllKeyInArry(key, value, null);
    }

    public List<E> findAllKeyInArry(String key, final Object[] value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (this.checkThowInParmException(value)) {
            return new ArrayList();
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.list();
            }
        });
    }

    public List<E> findAllKeyNotInArry(String key, Object[] value) {
        return this.findAllKeyNotInArry(key, value, null);
    }

    public List<E> findAllKeyNotInArry(String key, final Object[] value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        if (this.checkThowInParmException(value)) {
            return new ArrayList();
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        sb.append(this.appendSortSql(order));
        final String hql = sb.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.list();
            }
        });
    }

    private PageRequest initAndCheckEntityColumn(PageRequest pageReq) {
        Class<E> entityClass = this.getEntityClass();
        BaseDaoTableParm parm = new BaseDaoTableParm(entityClass);
        return PageUtils.changeEntityParm((PageRequest)pageReq, parm.getEntrySql(), (boolean)true);
    }

    public Page<E> findPageByMoreParam(PageRequest pageReq, Map<String, Object> mapParm, Map<String, Object[]> inmap, String searchColumns) {
        return this.findPageByMoresParam(pageReq, mapParm, null, inmap, null, null, searchColumns);
    }

    public Page findPageByMoresParam(PageRequest pageReq, Map<String, Object> mapParm, Map<String, Object> notParm, Map<String, Object[]> inmap, Map<String, Object[]> notinmap, String columns, String searchColumns) {
        return this.findPageByMoresParam(pageReq, mapParm, notParm, inmap, notinmap, null, columns, searchColumns);
    }

    public Page findPageByMoresParam(PageRequest pageReq, Map<String, Object> mapParm, Map<String, Object> notParm, Map<String, Object[]> inmap, Map<String, Object[]> notinmap, Map<String, Date> dateParm, String columns, String searchColumns) {
        return this.findPageByMoresOrParam(pageReq, mapParm, notParm, inmap, notinmap, dateParm, null, columns, searchColumns);
    }

    public Page findPageByMoresOrParam(final PageRequest pageReq, final Map<String, Object> mapParm, final Map<String, Object> notParm, final Map<String, Object[]> inmap, final Map<String, Object[]> notinmap, final Map<String, Date> dateParm, final List<DaoCustomParm> orParm, String columns, String searchColumns) {
        Iterator<DaoCustomParm> orParmiterator;
        Iterator<Map.Entry<String, Object[]>> notinmapiterator;
        Iterator<Map.Entry<String, Object[]>> inmapiterator;
        Iterator<Map.Entry<String, Object>> notParmiterator;
        Iterator<Map.Entry<String, Object>> iterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        StringBuffer sbTotal = new StringBuffer("SELECT COUNT(*) ");
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Date>> dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
        int datecount = 0;
        while (null != dateParmiterator && dateParmiterator.hasNext()) {
            Map.Entry<String, Date> entry = dateParmiterator.next();
            if (null == entry.getValue()) continue;
            sb.append(" AND ");
            sb.append(entry.getKey().replaceAll("&&", " "));
            sb.append(" :date_");
            sb.append(datecount);
            ++datecount;
            ++count;
        }
        Iterator<Map.Entry<String, Object>> iterator2 = iterator = mapParm == null ? null : mapParm.entrySet().iterator();
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object>> iterator3 = notParmiterator = notParm == null ? null : notParm.entrySet().iterator();
        while (null != notParmiterator && notParmiterator.hasNext()) {
            Map.Entry<String, Object> entry = notParmiterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :not_");
                sb.append(entry.getKey());
            }
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator4 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
        while (null != inmapiterator && inmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = inmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            sb.append(" AND ");
            sb.append(entry.getKey());
            sb.append(" IN (:i_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        Iterator<Map.Entry<String, Object[]>> iterator5 = notinmapiterator = notinmap == null ? null : notinmap.entrySet().iterator();
        while (null != notinmapiterator && notinmapiterator.hasNext()) {
            Map.Entry<String, Object[]> entry = notinmapiterator.next();
            if (this.checkThowInParmException(entry.getValue())) continue;
            sb.append(" AND ");
            sb.append(entry.getKey());
            sb.append(" NOT IN (:noti_");
            sb.append(entry.getKey());
            sb.append(")");
            ++count;
        }
        int orcount = 0;
        Iterator<DaoCustomParm> iterator6 = orParmiterator = orParm == null ? null : orParm.iterator();
        while (null != orParmiterator && orParmiterator.hasNext()) {
            DaoCustomParm entry = orParmiterator.next();
            if (orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if ("do_eq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NULL ");
                } else {
                    sb.append(" = :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_neq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NOT NULL ");
                } else {
                    sb.append(" <> :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_in".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_notin".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" NOT IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else {
                throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
            }
            ++orcount;
        }
        if (orcount > 0) {
            sb.append(" ) ");
        }
        this.agParmFilterAppend(pageReq, sb, true);
        if (count == 0) {
            return new Page(pageReq, 0);
        }
        final boolean isSerach = StringUtils.isNotBlank((CharSequence)searchColumns);
        if (isSerach && StringUtils.isNotBlank((CharSequence)pageReq.getsSearch()) && StringUtils.isNotEmpty((CharSequence)pageReq.getsSearch())) {
            String[] searcColums = searchColumns.split(",");
            sb.append(" AND (");
            for (int i = 0; i < searcColums.length; ++i) {
                if (i != 0) {
                    sb.append(" OR ");
                }
                sb.append(searcColums[i]);
                sb.append(" LIKE :s_search ");
            }
            sb.append(")");
        }
        StringBuffer sbcolumns = new StringBuffer(2000);
        final boolean isSeraceColumn = !BaseHibernateDao.isEmpty(columns);
        int columnCount = 0;
        if (isSeraceColumn) {
            sbcolumns.append("SELECT ");
            String[] arry = columns.split(",");
            for (int i = 0; i < arry.length; ++i) {
                if (i != 0) {
                    sbcolumns.append(", ");
                }
                sbcolumns.append(arry[i]);
                sbcolumns.append(" AS ");
                sbcolumns.append(arry[i]);
                ++columnCount;
            }
        }
        final int finalcolumnCount = columnCount;
        sbTotal.append(sb);
        final String totalHql = sbTotal.toString();
        sbcolumns.append(sb).append(this.appendSortSql(pageReq.getSortColumns()));
        final String hql = sbcolumns.toString();
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator orParmiterator;
                Iterator notinmapiterator;
                Iterator inmapiterator;
                Iterator notParmiterator;
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                org.hibernate.query.Query totalQuery = session.createQuery(totalHql);
                if (isSeraceColumn && finalcolumnCount != 1) {
                    query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                }
                Iterator iterator2 = iterator = mapParm == null ? null : mapParm.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                    totalQuery.setParameter((String)entry.getKey(), entry.getValue());
                }
                Iterator dateParmiterator = dateParm == null ? null : dateParm.entrySet().iterator();
                int datecount = 0;
                while (null != dateParmiterator && dateParmiterator.hasNext()) {
                    Map.Entry entry = dateParmiterator.next();
                    if (null != entry.getValue()) {
                        query.setParameter("date_" + datecount, entry.getValue(), (Type)StandardBasicTypes.DATE);
                        totalQuery.setParameter("date_" + datecount, entry.getValue(), (Type)StandardBasicTypes.DATE);
                    }
                    ++datecount;
                }
                Iterator iterator3 = notParmiterator = notParm == null ? null : notParm.entrySet().iterator();
                while (null != notParmiterator && notParmiterator.hasNext()) {
                    Map.Entry entry = notParmiterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                    totalQuery.setParameter("not_" + (String)entry.getKey(), entry.getValue());
                }
                Iterator iterator4 = inmapiterator = inmap == null ? null : inmap.entrySet().iterator();
                while (null != inmapiterator && inmapiterator.hasNext()) {
                    Map.Entry entry = inmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                    totalQuery.setParameterList("i_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                Iterator iterator5 = notinmapiterator = notinmap == null ? null : notinmap.entrySet().iterator();
                while (null != notinmapiterator && notinmapiterator.hasNext()) {
                    Map.Entry entry = notinmapiterator.next();
                    if (BaseHibernateDao.this.checkThowInParmException((Object[])entry.getValue())) continue;
                    query.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                    totalQuery.setParameterList("noti_" + (String)entry.getKey(), (Object[])entry.getValue());
                }
                int orcount = 0;
                Iterator iterator6 = orParmiterator = orParm == null ? null : orParm.iterator();
                while (null != orParmiterator && orParmiterator.hasNext()) {
                    DaoCustomParm entry = (DaoCustomParm)orParmiterator.next();
                    if ("do_eq".equals(entry.getDoType()) || "do_neq".equals(entry.getDoType())) {
                        if (null != entry.getParm()) {
                            query.setParameter("or_" + orcount + entry.getKey(), entry.getParm());
                            totalQuery.setParameter("or_" + orcount + entry.getKey(), entry.getParm());
                        }
                    } else if ("do_in".equals(entry.getDoType()) || "do_notin".equals(entry.getDoType())) {
                        query.setParameterList("or_" + orcount + entry.getKey(), entry.getInParm());
                        totalQuery.setParameterList("or_" + orcount + entry.getKey(), entry.getInParm());
                    } else {
                        throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
                    }
                    ++orcount;
                }
                if (isSerach && StringUtils.isNotBlank((CharSequence)pageReq.getsSearch()) && StringUtils.isNotEmpty((CharSequence)pageReq.getsSearch())) {
                    query.setParameter("s_search", (Object)("%" + pageReq.getsSearch() + "%"));
                    totalQuery.setParameter("s_search", (Object)("%" + pageReq.getsSearch() + "%"));
                }
                BaseHibernateDao.agParmSet(pageReq, (Query)query, (Query)totalQuery);
                return PageQueryUtils.executeQueryForPage((PageRequest)pageReq, (Query)query, (Query)totalQuery);
            }
        });
    }

    public int deleteAllKeyInArry(String key, final Object[] value) {
        if (this.checkThowInParmException(value)) {
            return 0;
        }
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllKeyNotInArry(String key, final Object[] value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        if (this.checkThowInParmException(value)) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        sb.append(" NOT IN (:value) ");
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                query.setParameterList("value", value);
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllByMapFK(final Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> iterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Object>> iterator2 = iterator = map == null ? null : map.entrySet().iterator();
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NULL ");
            } else {
                sb.append(" = :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = map == null ? null : map.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllNotByMapFK(final Map<String, Object> notmap) {
        Iterator<Map.Entry<String, Object>> iterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<Map.Entry<String, Object>> iterator2 = iterator = notmap == null ? null : notmap.entrySet().iterator();
        while (null != iterator && iterator.hasNext()) {
            Map.Entry<String, Object> entry = iterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if (null == entry.getValue()) {
                sb.append(" IS NOT NULL ");
            } else {
                sb.append(" <> :");
                sb.append(entry.getKey());
            }
            ++count;
        }
        if (count == 0) {
            return 0;
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator iterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                Iterator iterator2 = iterator = notmap == null ? null : notmap.entrySet().iterator();
                while (null != iterator && iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (null == entry.getValue()) continue;
                    query.setParameter((String)entry.getKey(), entry.getValue());
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllByKey(String key, final Object value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                return query.executeUpdate();
            }
        });
    }

    public int deleteAllNotByKey(String key, final Object value) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        StringBuffer sb = new StringBuffer(" DELETE ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NOT NULL ");
        } else {
            sb.append(" <> :value ");
        }
        final String hql = sb.toString();
        return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                if (null != value) {
                    query.setParameter("value", value);
                }
                return query.executeUpdate();
            }
        });
    }

    public void deleteById(PK id) {
        if (!this.verifyLicense.licInfoVerify()) {
            return;
        }
        E entity = this.getById(id);
        if (entity == null) {
            throw new ObjectRetrievalFailureException(this.getEntityClass(), id);
        }
        this.getHibernateTemplate().delete(entity);
    }

    @Override
    public void update(E entity) {
        this.prepareObjectForUpdate(entity);
        this.getHibernateTemplate().update(entity);
    }

    @Override
    public Page<E> findPage(PageRequest pageRequest, Object parameters) {
        return this.findPageAllByParam(pageRequest, parameters);
    }

    public void saveOrUpdate(E entity) {
        this.getHibernateTemplate().saveOrUpdate(entity);
    }

    public int saveAll(Collection<E> entities) {
        return this.saveOrUpdateAll(entities);
    }

    public int saveOrUpdateAll(final Collection<E> entities) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        if (null != entities && entities.size() > 0) {
            if (entities.size() < 0) {
                this.getHibernateTemplate().saveOrUpdate(entities.iterator().next());
                return entities.size();
            }
            Class<E> clazz = this.getEntityClass();
            BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("INSERT INTO ");
            sb.append(parm.getTableName());
            sb.append("(");
            final List<String> entrycolumns = parm.getEntrycolumns();
            List<String> sqlColumns = parm.getSqlColumns();
            StringBuffer upsb = new StringBuffer(200);
            for (int i = 0; i < sqlColumns.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(sqlColumns.get(i));
                if (parm.getSqlIdField().equals(sqlColumns.get(i))) continue;
                if (upsb.length() != 0) {
                    upsb.append(", ");
                }
                upsb.append(sqlColumns.get(i));
                upsb.append("=VALUES(");
                upsb.append(sqlColumns.get(i));
                upsb.append(")");
            }
            sb.append(") VALUES ");
            Iterator<E> it = entities.iterator();
            int i = 0;
            int parmNum = 0;
            while (it.hasNext()) {
                E obj = it.next();
                JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                if (null == eObj) continue;
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("(");
                for (int j = 0; j < entrycolumns.size(); ++j) {
                    Object value;
                    if (j != 0) {
                        sb.append(", ");
                    }
                    if (null == (value = eObj.get((Object)entrycolumns.get(j)))) {
                        if (parm.isGeneratorUuid() && parm.getEntryIdField().equals(entrycolumns.get(j))) {
                            sb.append("UUID()");
                            continue;
                        }
                        sb.append("NULL");
                        continue;
                    }
                    sb.append("?");
                    sb.append(parmNum);
                    ++parmNum;
                }
                sb.append(")");
                ++i;
            }
            sb.append(" ON DUPLICATE KEY UPDATE ");
            sb.append(upsb);
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    NativeQuery query = session.createSQLQuery(sql);
                    int count = 0;
                    for (Object obj : entities) {
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        if (null == eObj) continue;
                        for (int j = 0; j < entrycolumns.size(); ++j) {
                            Object value = eObj.get(entrycolumns.get(j));
                            if (null == value) continue;
                            query.setParameter(count, value);
                            ++count;
                        }
                    }
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public int saveOrUpdateColumns(final Collection<E> entities, String updateColumns) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        if (StringUtils.isBlank((CharSequence)updateColumns)) {
            throw new NullPointerException("\u66f4\u65b0\u5217\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null != entities && entities.size() > 0) {
            Class<E> clazz = this.getEntityClass();
            BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("INSERT INTO ");
            sb.append(parm.getTableName());
            sb.append("(");
            final List<String> entrycolumns = parm.getEntrycolumns();
            List<String> sqlColumns = parm.getSqlColumns();
            StringBuffer upsb = new StringBuffer(200);
            updateColumns = updateColumns.replaceAll("\\s+", "");
            String[] updateColumn = updateColumns.trim().split(",");
            for (int i = 0; i < sqlColumns.size(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(sqlColumns.get(i));
            }
            Map<String, BaseDaoTableColumn> columnMap = parm.getColumns();
            for (int i = 0; i < updateColumn.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)updateColumn[i]) || parm.getEntryIdField().equals(updateColumn[i])) continue;
                if (!columnMap.containsKey(updateColumn[i])) {
                    this.log.error("\u5b9e\u4f53\u4e2d\u914d\u7f6e\u4e2d\u672a\u53d1\u73b0\u6307\u5b9a\u5217{}", (Object)updateColumn[i]);
                    continue;
                }
                String sqlField = columnMap.get(updateColumn[i]).getSqlField();
                if (upsb.length() != 0) {
                    upsb.append(", ");
                }
                upsb.append(sqlField);
                upsb.append("=VALUES(");
                upsb.append(sqlField);
                upsb.append(")");
            }
            sb.append(") VALUES ");
            Iterator<E> it = entities.iterator();
            int i = 0;
            int parmNum = 0;
            while (it.hasNext()) {
                E obj = it.next();
                JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                if (null == eObj) continue;
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append("(");
                for (int j = 0; j < entrycolumns.size(); ++j) {
                    Object value;
                    if (j != 0) {
                        sb.append(", ");
                    }
                    if (null == (value = eObj.get((Object)entrycolumns.get(j)))) {
                        if (parm.isGeneratorUuid() && parm.getEntryIdField().equals(entrycolumns.get(j))) {
                            sb.append("UUID()");
                            continue;
                        }
                        sb.append("NULL");
                        continue;
                    }
                    sb.append("?");
                    sb.append(parmNum);
                    ++parmNum;
                }
                sb.append(")");
                ++i;
            }
            sb.append(" ON DUPLICATE KEY UPDATE ");
            sb.append(upsb);
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    NativeQuery query = session.createSQLQuery(sql);
                    int count = 0;
                    for (Object obj : entities) {
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        if (null == eObj) continue;
                        for (int j = 0; j < entrycolumns.size(); ++j) {
                            Object value = eObj.get(entrycolumns.get(j));
                            if (null == value) continue;
                            query.setParameter(count, value);
                            ++count;
                        }
                    }
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public int deleteAll(final Collection<E> entities) {
        if (!this.verifyLicense.licInfoVerify()) {
            return 0;
        }
        if (null != entities && entities.size() > 0) {
            if (entities.size() == 1) {
                this.getHibernateTemplate().deleteAll(entities);
                return entities.size();
            }
            Class<E> clazz = this.getEntityClass();
            final BaseDaoTableParm parm = new BaseDaoTableParm(clazz);
            StringBuffer sb = new StringBuffer(2000);
            sb.append("DELETE FROM ");
            sb.append(parm.getTableName());
            sb.append(" WHERE ");
            sb.append(parm.getSqlIdField());
            sb.append(" IN (:ids)");
            final String sql = sb.toString();
            return (Integer)this.getHibernateTemplate().execute(new HibernateCallback(){

                public Object doInHibernate(Session session) throws HibernateException {
                    NativeQuery query = session.createSQLQuery(sql);
                    Iterator list = entities.iterator();
                    ArrayList<String> ids = new ArrayList<String>();
                    while (list.hasNext()) {
                        Object obj = list.next();
                        JSONObject eObj = (JSONObject)JSONObject.toJSON(obj);
                        String id = (String)eObj.get((Object)parm.getEntryIdField());
                        ids.add(id);
                    }
                    query.setParameterList("ids", ids);
                    return query.executeUpdate();
                }
            });
        }
        return 0;
    }

    public void refresh(Object entity) {
        this.getHibernateTemplate().refresh(entity);
    }

    public void flush() {
        this.getHibernateTemplate().flush();
    }

    public void evict(Object entity) {
        if (null != entity) {
            this.getHibernateTemplate().evict(entity);
        }
    }

    public void clear() {
        this.getHibernateTemplate().clear();
    }

    public E findFirst(E entity) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        List list = this.getHibernateTemplate().findByExample(entity, 0, 1);
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    public List<E> findAll() {
        return this.findAll("");
    }

    public List<E> findAll(String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        queryStringBuff.append(this.appendSortSql(order));
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                return query.list();
            }
        });
    }

    public Page findAll(PageRequest pageRequest) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        queryStringBuff.append(this.appendSortSql(pageRequest.getSortColumns()));
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                org.hibernate.query.Query countQuery = session.createQuery(countQueryString);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    public Page findPageAllByParam(PageRequest pageRequest, Object parameters) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, pageRequest);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        queryStringBuff.append(this.appendSortSql(pageRequest.getSortColumns()));
        final String queryString = queryStringBuff.toString();
        this.log.info("---------queryString:  {}", (Object)queryString);
        final PageRequest finalPageRequest = pageRequest;
        final Object finalparameters = parameters;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                BaseHibernateDao.this.initSearchProperties((Query)query, finalPageRequest, finalparameters);
                org.hibernate.query.Query countQuery = session.createQuery(countQueryString);
                BaseHibernateDao.this.initSearchProperties((Query)countQuery, finalPageRequest, finalparameters);
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    private void initSearchProperties(Query querySearch, PageRequest finalPageRequest, Object parameters) {
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Set objSet = obj.keySet();
            int count = 0;
            for (String key : objSet) {
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)value) || "null".equals(value)) continue;
                querySearch.setParameter(count, (Object)value);
                this.log.info("kcolumnStr:{} count:{} value:{}", new Object[]{key, count, value});
                ++count;
            }
            if (null != finalPageRequest) {
                if (StringUtils.isNotBlank((CharSequence)finalPageRequest.getsSearch()) && StringUtils.isNotEmpty((CharSequence)finalPageRequest.getsSearch())) {
                    for (String columnStr : objSet) {
                        if (columnStr.indexOf("Date") != -1 || columnStr.indexOf("date") != -1 || columnStr.indexOf("Time") != -1 || columnStr.indexOf("Type") != -1) continue;
                        this.log.info("columnStr:{} count:{} searCh:{}", new Object[]{columnStr, count, finalPageRequest.getsSearch()});
                        querySearch.setParameter(count, (Object)("%" + finalPageRequest.getsSearch() + "%"));
                        ++count;
                    }
                }
                BaseHibernateDao.agParmSet(finalPageRequest, querySearch, null);
            }
        }
    }

    @Deprecated
    public Page findPageAllByInProperty(PageRequest pageRequest, Map parametersIn) {
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String countQueryString = "SELECT count(*) " + queryStringBuff.toString();
        queryStringBuff.append(this.appendSortSql(pageRequest.getSortColumns()));
        final String queryString = queryStringBuff.toString();
        final PageRequest finalPageRequest = pageRequest;
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                org.hibernate.query.Query countQuery = session.createQuery(countQueryString);
                if (ls != null && ls.size() > 0) {
                    countQuery.setParameterList("list", (Collection)ls);
                }
                return PageQueryUtils.executeQueryForPage((PageRequest)finalPageRequest, (Query)query, (Query)countQuery);
            }
        });
    }

    @Deprecated
    public List findPageAllNoPageByInProperty(Map parametersIn) {
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final List ls = this.initQueryPramaIn(parametersIn, queryStringBuff);
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                if (ls != null && ls.size() > 0) {
                    query.setParameterList("list", (Collection)ls);
                }
                return query.list();
            }
        });
    }

    public List findAllByParam(Object parameters) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        this.initQueryPrama(parameters, queryStringBuff, null);
        queryStringBuff.append(this.appendSortSql(null));
        final String queryString = queryStringBuff.toString();
        final Object finalparameters = parameters;
        return (List)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                BaseHibernateDao.this.initSearchProperties((Query)query, null, finalparameters);
                return query.list();
            }
        });
    }

    public List findAllByParamLike(Object parameters) {
        StringBuffer queryStringBuff = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        final String param = this.initQueryPramaLike(parameters, queryStringBuff);
        queryStringBuff.append(this.appendSortSql(null));
        final String queryString = queryStringBuff.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(queryString);
                query.setString("param", param + "%");
                return query.list();
            }
        });
    }

    public Page<?> pageQuery(String hql, PageRequest pageRequest, Object parameters) {
        String countHql = PageQueryUtils.createCountSql((String)hql);
        return this.pageQuery(hql, countHql, pageRequest, parameters);
    }

    public Page<?> pageQuery(String hql, String countHql, PageRequest pageRequest, Object parameters) {
        return PageQueryUtils.pageQuery((HibernateTemplate)this.getHibernateTemplate(), (String)hql, (String)countHql, (PageRequest)pageRequest, (Object)parameters);
    }

    private static boolean isEmpty(Object id) {
        if (id == null) {
            return true;
        }
        if (id instanceof String) {
            return StringUtils.isEmpty((CharSequence)((String)id));
        }
        return false;
    }

    private void initQueryPrama(Object parameters, StringBuffer queryStringBuff, PageRequest pageRequest) {
        if (parameters == null && null == pageRequest) {
            return;
        }
        if (parameters == null && StringUtils.isEmpty((CharSequence)pageRequest.getsSearch()) && StringUtils.isBlank((CharSequence)pageRequest.getsSearch())) {
            return;
        }
        JSONObject obj = null;
        ArrayList<String> ls = new ArrayList<String>();
        if (parameters != null) {
            obj = this.covertJsonFromObject(parameters);
            for (String key : obj.keySet()) {
                String value = obj.getString(key);
                if (!StringUtils.isNotEmpty((CharSequence)value) || !StringUtils.isNotBlank((CharSequence)value) || "null".equals(value)) continue;
                ls.add(key);
            }
        }
        if (ls.size() > 0) {
            queryStringBuff.append(" c where ");
            for (int j = 0; j < ls.size(); ++j) {
                queryStringBuff.append(" c." + ls.get(j) + "= ?" + j + " ");
                if (j >= ls.size() - 1) continue;
                queryStringBuff.append(" and ");
            }
        }
        if (pageRequest != null) {
            AgParm agParm;
            boolean isHaveWhere = false;
            if (StringUtils.isNotEmpty((CharSequence)pageRequest.getsSearch()) && StringUtils.isNotBlank((CharSequence)pageRequest.getsSearch())) {
                if (ls.size() == 0) {
                    queryStringBuff.append(" c where ");
                    isHaveWhere = true;
                } else {
                    queryStringBuff.append(" and ");
                }
                queryStringBuff.append(this.constructionSearchQuery(obj));
            }
            if ((agParm = pageRequest.getAgParm()) != null && agParm.getCount() > 0) {
                if (isHaveWhere) {
                    queryStringBuff.append(" and ");
                } else {
                    queryStringBuff.append(" c where ");
                }
                queryStringBuff.append(agParm.getConditionSql("c."));
            }
        }
    }

    private String constructionSearchQuery(JSONObject obj) {
        StringBuffer sbufferSearch = new StringBuffer();
        Set objset = obj.keySet();
        ArrayList<String> lsobj = new ArrayList<String>();
        if (null != objset && objset.size() > 0) {
            for (Object object : objset) {
                String key = (String)object;
                if (key.indexOf("Date") != -1 || key.indexOf("date") != -1 || key.indexOf("Time") != -1 || key.indexOf("Type") != -1) continue;
                lsobj.add(key);
            }
            sbufferSearch.append("(");
            for (int i = 0; i < lsobj.size(); ++i) {
                if (i == lsobj.size() - 1) {
                    sbufferSearch.append("c." + (String)lsobj.get(i) + " like ?" + i + " )");
                    continue;
                }
                sbufferSearch.append("c." + (String)lsobj.get(i) + " like ?" + i + " or ");
            }
        }
        return sbufferSearch.toString();
    }

    private List initQueryPramaIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " in (:list) ");
            }
        }
        return valueLs;
    }

    private List initQueryPramaNotIn(Map parametersIn, StringBuffer queryStringBuff) {
        List valueLs = new ArrayList();
        if (parametersIn != null) {
            Iterator iterator = parametersIn.entrySet().iterator();
            String keyStr = "";
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                keyStr = (String)entry.getKey();
                valueLs = (List)entry.getValue();
            }
            if (valueLs != null && valueLs.size() > 0) {
                queryStringBuff.append(" c where ");
                queryStringBuff.append(" c." + keyStr + " not in (:list) ");
            }
        }
        return valueLs;
    }

    private String initQueryPramaLike(Object parameters, StringBuffer queryStringBuff) {
        String likeValue = "";
        if (parameters != null) {
            JSONObject obj = this.covertJsonFromObject(parameters);
            Iterator it = obj.keySet().iterator();
            ArrayList<String> ls = new ArrayList<String>();
            while (it.hasNext()) {
                String value;
                String key = (String)it.next();
                String value1 = obj.getString(key);
                if (!(value1 instanceof String) || !StringUtils.isNotEmpty((CharSequence)(value = value1)) || !StringUtils.isNotBlank((CharSequence)value) || "null".equals(value)) continue;
                ls.add(key);
                likeValue = value;
                break;
            }
            if (ls.size() > 0) {
                queryStringBuff.append(" c where ");
                for (int j = 0; j < ls.size(); ++j) {
                    queryStringBuff.append(" c." + (String)ls.get(j) + " like:param");
                    if (j >= ls.size() - 1) continue;
                    queryStringBuff.append(" and ");
                }
            }
        }
        return likeValue;
    }

    private JSONObject covertJsonFromObject(Object parameters) {
        JSONObject obj = (JSONObject)JSONObject.toJSON((Object)parameters);
        return obj;
    }

    public Page<E> findPageAllKeyInArry(PageRequest pageReq, String key, Object[] value) {
        return this.findPageAllKeyInArry(pageReq, key, value, null);
    }

    public Page<E> findPageAllKeyInArry(final PageRequest pageReq, String key, final Object[] value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sbTotal = new StringBuffer("SELECT COUNT(*) FROM ").append(this.getEntityClass().getSimpleName());
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        StringBuffer sbWHERE = new StringBuffer(" WHERE 1=1 ");
        if (!this.checkThowInParmException(value)) {
            sbWHERE.append(" AND ");
            sbWHERE.append(key);
            sbWHERE.append(" IN (:value) ");
        }
        this.agParmFilterAppend(pageReq, sbWHERE, true);
        sbTotal.append(sbWHERE);
        final String hqlTotal = sbTotal.toString();
        sb.append(sbWHERE);
        sb.append(this.appendSortSql(pageReq, order));
        final String hql = sb.toString();
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                org.hibernate.query.Query totalQuery = session.createQuery(hqlTotal);
                if (!BaseHibernateDao.this.checkThowInParmException(value)) {
                    query.setParameterList("value", value);
                    totalQuery.setParameterList("value", value);
                }
                BaseHibernateDao.agParmSet(pageReq, (Query)query, (Query)totalQuery);
                return PageQueryUtils.executeQueryForPage((PageRequest)pageReq, (Query)query, (Query)totalQuery);
            }
        });
    }

    public Page<E> findPageAllByFK(PageRequest pageReq, String key, Object value) {
        return this.findPageAllByFK(pageReq, key, value, null);
    }

    public Page<E> findPageAllByFK(final PageRequest pageReq, String key, final Object value, String order) {
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sbTotal = new StringBuffer("SELECT COUNT(*) ");
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE ");
        sb.append(key);
        if (null == value) {
            sb.append(" IS NULL ");
        } else {
            sb.append(" = :value ");
        }
        this.agParmFilterAppend(pageReq, sb, true);
        sbTotal.append(sb);
        final String hqlTotal = sbTotal.toString();
        sb.append(this.appendSortSql(pageReq, order));
        final String hql = sb.toString();
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                org.hibernate.query.Query query = session.createQuery(hql);
                org.hibernate.query.Query totalQuery = session.createQuery(hqlTotal);
                if (null != value) {
                    query.setParameter("value", value);
                    totalQuery.setParameter("value", value);
                }
                BaseHibernateDao.agParmSet(pageReq, (Query)query, (Query)totalQuery);
                return PageQueryUtils.executeQueryForPage((PageRequest)pageReq, (Query)query, (Query)totalQuery);
            }
        });
    }

    public void agParmFilterAppend(PageRequest pageReq, StringBuffer sb, boolean isOnlyCheck) {
        if (isOnlyCheck) {
            pageReq = this.initAndCheckEntityColumn(pageReq);
        }
        BaseHibernateDao.agParmFilterAppend(pageReq, sb, null);
    }

    public static void agParmFilterAppend(PageRequest pageReq, StringBuffer sb) {
        BaseHibernateDao.agParmFilterAppend(pageReq, sb, null);
    }

    public static void agParmFilterAppend(PageRequest pageReq, StringBuffer sb, String aliasName) {
        AgParm agParm;
        if (StringUtils.isEmpty((CharSequence)aliasName) || !aliasName.endsWith(".")) {
            aliasName = "";
        }
        if ((agParm = pageReq.getAgParm()) != null && agParm.getCount() > 0) {
            sb.append(" AND ");
            sb.append(agParm.getConditionSql(aliasName));
        }
    }

    public static void agParmSet(PageRequest pageReq, Query query, Query totalQuery) {
        AgParm agParm = pageReq.getAgParm();
        if (agParm != null && agParm.getCount() > 0 && !agParm.getValueParmsKeys().isEmpty()) {
            Iterator agParmIterator = agParm.getValueParmsKeys().entrySet().iterator();
            while (null != agParmIterator && agParmIterator.hasNext()) {
                Map.Entry entry = agParmIterator.next();
                if (((String)entry.getKey()).startsWith(":set_")) {
                    query.setParameterList((String)entry.getKey(), (Collection)((List)entry.getValue()));
                    if (totalQuery == null) continue;
                    totalQuery.setParameterList((String)entry.getKey(), (Collection)((List)entry.getValue()));
                    continue;
                }
                Type agParameterType = BaseHibernateDao.getAgParameterType((String)entry.getKey());
                if (agParameterType == null) {
                    query.setParameter((String)entry.getKey(), entry.getValue());
                    if (totalQuery == null) continue;
                    totalQuery.setParameter((String)entry.getKey(), entry.getValue());
                    continue;
                }
                query.setParameter((String)entry.getKey(), entry.getValue(), agParameterType);
                if (totalQuery == null) continue;
                totalQuery.setParameter((String)entry.getKey(), entry.getValue(), agParameterType);
            }
        }
    }

    public static Type getAgParameterType(String key) {
        if (key.startsWith("date_")) {
            return StandardBasicTypes.DATE;
        }
        if (key.startsWith("time_")) {
            return StandardBasicTypes.TIME;
        }
        if (key.startsWith("number_")) {
            return StandardBasicTypes.BIG_DECIMAL;
        }
        return null;
    }

    public List<E> findAllByDaoCustomParm(List<DaoCustomParm> parm, List<DaoCustomParm> orParm) {
        return this.findAllByDaoCustomParm(parm, orParm, null, null);
    }

    public E findFirstByDaoCustomParm(List<DaoCustomParm> parm) {
        List allByDaoCustomParm = this.findAllByDaoCustomParm(parm, null, null, null);
        if (StrUtil.listIsNull((Collection)allByDaoCustomParm)) {
            return null;
        }
        return allByDaoCustomParm.get(0);
    }

    public List<E> findAllByDaoCustomParm(List<DaoCustomParm> parm) {
        return this.findAllByDaoCustomParm(parm, null, null, null);
    }

    public List findAllByDaoCustomParm(List<DaoCustomParm> parm, List<DaoCustomParm> orParm, String columns) {
        return this.findAllByDaoCustomParm(parm, orParm, columns, null);
    }

    public List findAllByDaoCustomParm(final List<DaoCustomParm> parm, final List<DaoCustomParm> orParm, String columns, String order) {
        boolean isSeraceColumn;
        Iterator<DaoCustomParm> orParmiterator;
        Iterator<DaoCustomParm> parmiterator;
        if (!this.verifyLicense.licInfoVerify()) {
            return null;
        }
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        boolean datecount = false;
        Iterator<DaoCustomParm> iterator = parmiterator = parm == null ? null : parm.iterator();
        while (null != parmiterator && parmiterator.hasNext()) {
            DaoCustomParm entry = parmiterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if ("do_eq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NULL ");
                } else {
                    sb.append(" = :p_");
                    sb.append(count);
                    sb.append(entry.getKey());
                }
            } else if ("do_neq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NOT NULL ");
                } else {
                    sb.append(" <> :p_");
                    sb.append(count);
                    sb.append(entry.getKey());
                }
            } else if ("do_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" like :p_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_not_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" not like :p_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_in".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" IN (:p_");
                sb.append(count);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_notin".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" NOT IN (:p_");
                sb.append(count);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_date_gt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" > :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_gte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" >= :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_lt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" < :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_lte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" <= :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_gt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" > :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_gte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" >= :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_lt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" < :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_lte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" <= :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else {
                throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
            }
            ++count;
        }
        int orcount = 0;
        Iterator<DaoCustomParm> iterator2 = orParmiterator = orParm == null ? null : orParm.iterator();
        while (null != orParmiterator && orParmiterator.hasNext()) {
            DaoCustomParm entry = orParmiterator.next();
            if (orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if ("do_eq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NULL ");
                } else {
                    sb.append(" = :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_neq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NOT NULL ");
                } else {
                    sb.append(" <> :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" like :or_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_not_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" not like :or_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_in".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_notin".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" NOT IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_date_gt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" > :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_gte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" >= :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_lt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" < :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_lte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" <= :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_gt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" > :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_gte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" >= :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_lt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" < :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_lte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" <= :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else {
                throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
            }
            ++orcount;
        }
        if (orcount > 0) {
            sb.append(" ) ");
        }
        if (count == 0 && orcount == 0) {
            return Collections.emptyList();
        }
        int columnCount = 0;
        StringBuffer sbcolumns = new StringBuffer(2000);
        boolean bl = isSeraceColumn = !BaseHibernateDao.isEmpty(columns);
        if (isSeraceColumn) {
            sbcolumns.append("SELECT ");
            String[] arry = columns.split(",");
            for (int i = 0; i < arry.length; ++i) {
                if (i != 0) {
                    sbcolumns.append(", ");
                }
                sbcolumns.append(arry[i]);
                sbcolumns.append(" AS ");
                sbcolumns.append(arry[i]);
                ++columnCount;
            }
        }
        final int finalcolumnCount = columnCount;
        sbcolumns.append(sb).append(this.appendSortSql(order));
        final String hql = sbcolumns.toString();
        return (List)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator orParmiterator;
                Iterator parmiterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                int count = 0;
                Iterator iterator = parmiterator = parm == null ? null : parm.iterator();
                while (null != parmiterator && parmiterator.hasNext()) {
                    DaoCustomParm entry = (DaoCustomParm)parmiterator.next();
                    if ("do_eq".equals(entry.getDoType()) || "do_neq".equals(entry.getDoType())) {
                        if (null != entry.getParm()) {
                            query.setParameter("p_" + count + entry.getKey(), entry.getParm());
                        }
                    } else if ("do_like".equals(entry.getDoType()) || "do_not_like".equals(entry.getDoType())) {
                        query.setParameter("p_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                    } else if ("do_in".equals(entry.getDoType()) || "do_notin".equals(entry.getDoType())) {
                        query.setParameterList("p_" + count + entry.getKey(), entry.getInParm());
                    } else if ("do_date_lt".equals(entry.getDoType()) || "do_date_lte".equals(entry.getDoType()) || "do_date_gt".equals(entry.getDoType()) || "do_date_gte".equals(entry.getDoType())) {
                        query.setParameter("date_" + count + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                    } else if ("do_num_lt".equals(entry.getDoType()) || "do_num_lte".equals(entry.getDoType()) || "do_num_gt".equals(entry.getDoType()) || "do_num_gte".equals(entry.getDoType())) {
                        query.setParameter("number_" + count + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                    } else {
                        throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
                    }
                    ++count;
                }
                int orcount = 0;
                Iterator iterator2 = orParmiterator = orParm == null ? null : orParm.iterator();
                while (null != orParmiterator && orParmiterator.hasNext()) {
                    DaoCustomParm entry = (DaoCustomParm)orParmiterator.next();
                    if ("do_eq".equals(entry.getDoType()) || "do_neq".equals(entry.getDoType())) {
                        if (null != entry.getParm()) {
                            query.setParameter("or_" + orcount + entry.getKey(), entry.getParm());
                        }
                    } else if ("do_like".equals(entry.getDoType()) || "do_not_like".equals(entry.getDoType())) {
                        query.setParameter("or_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                    } else if ("do_in".equals(entry.getDoType()) || "do_notin".equals(entry.getDoType())) {
                        query.setParameterList("or_" + orcount + entry.getKey(), entry.getInParm());
                    } else if ("do_date_lt".equals(entry.getDoType()) || "do_date_lte".equals(entry.getDoType()) || "do_date_gt".equals(entry.getDoType()) || "do_date_gte".equals(entry.getDoType())) {
                        if (null == entry.getDateParm()) continue;
                        query.setParameter("or_date_" + orcount + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                    } else if ("do_num_lt".equals(entry.getDoType()) || "do_num_lte".equals(entry.getDoType()) || "do_num_gt".equals(entry.getDoType()) || "do_num_gte".equals(entry.getDoType())) {
                        if (null == entry.getDecimalParm()) continue;
                        query.setParameter("or_number_" + orcount + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                    } else {
                        throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
                    }
                    ++orcount;
                }
                if (isSeraceColumn && finalcolumnCount != 1) {
                    query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                }
                return query.list();
            }
        });
    }

    public Page findAllPageByDaoCustomParm(final PageRequest pageReq, final List<DaoCustomParm> parm, final List<DaoCustomParm> orParm, String columns, String order) {
        boolean isSeraceColumn;
        Iterator<DaoCustomParm> orParmiterator;
        Iterator<DaoCustomParm> parmiterator;
        StringBuffer sb = new StringBuffer(" FROM ").append(this.getEntityClass().getSimpleName());
        sb.append(" WHERE 1=1 ");
        int count = 0;
        Iterator<DaoCustomParm> iterator = parmiterator = parm == null ? null : parm.iterator();
        while (null != parmiterator && parmiterator.hasNext()) {
            DaoCustomParm entry = parmiterator.next();
            sb.append(" AND ");
            sb.append(entry.getKey());
            if ("do_eq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NULL ");
                } else {
                    sb.append(" = :p_");
                    sb.append(count);
                    sb.append(entry.getKey());
                }
            } else if ("do_neq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NOT NULL ");
                } else {
                    sb.append(" <> :p_");
                    sb.append(count);
                    sb.append(entry.getKey());
                }
            } else if ("do_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" like :p_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_not_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" not like :p_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_in".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" IN (:p_");
                sb.append(count);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_notin".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" NOT IN (:p_");
                sb.append(count);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_date_gt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" > :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_gte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" >= :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_lt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" < :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_date_lte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" <= :date_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_gt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" > :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_gte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" >= :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_lt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" < :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_num_lte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" <= :number_");
                sb.append(count);
                sb.append(entry.getKey());
            } else {
                throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
            }
            ++count;
        }
        int orcount = 0;
        Iterator<DaoCustomParm> iterator2 = orParmiterator = orParm == null ? null : orParm.iterator();
        while (null != orParmiterator && orParmiterator.hasNext()) {
            DaoCustomParm entry = orParmiterator.next();
            if (orcount == 0) {
                sb.append(" AND ( ");
            }
            if (orcount > 0) {
                sb.append(" OR ");
            }
            sb.append(entry.getKey());
            if ("do_eq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NULL ");
                } else {
                    sb.append(" = :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_neq".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    sb.append(" IS NOT NULL ");
                } else {
                    sb.append(" <> :or_");
                    sb.append(orcount);
                    sb.append(entry.getKey());
                }
            } else if ("do_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" like :or_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_not_like".equals(entry.getDoType())) {
                if (null == entry.getParm()) {
                    this.log.error("like\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new BusinessException("like\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
                }
                sb.append(" not like :or_");
                sb.append(count);
                sb.append(entry.getKey());
            } else if ("do_in".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_notin".equals(entry.getDoType())) {
                if (this.checkThowInParmException(entry.getInParm())) continue;
                sb.append(" NOT IN (:or_");
                sb.append(orcount);
                sb.append(entry.getKey());
                sb.append(")");
            } else if ("do_date_gt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" > :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_gte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" >= :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_lt".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" < :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_date_lte".equals(entry.getDoType())) {
                if (null == entry.getDateParm()) continue;
                sb.append(" <= :or_date_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_gt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" > :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_gte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" >= :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_lt".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" < :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else if ("do_num_lte".equals(entry.getDoType())) {
                if (null == entry.getDecimalParm()) continue;
                sb.append(" <= :or_number_");
                sb.append(orcount);
                sb.append(entry.getKey());
            } else {
                throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
            }
            ++orcount;
        }
        if (orcount > 0) {
            sb.append(" ) ");
        }
        if (count == 0 && orcount == 0) {
            return new Page(pageReq, 0);
        }
        this.agParmFilterAppend(pageReq, sb, true);
        int columnCount = 0;
        StringBuffer sbcolumns = new StringBuffer(2000);
        boolean bl = isSeraceColumn = !BaseHibernateDao.isEmpty(columns);
        if (isSeraceColumn) {
            sbcolumns.append("SELECT ");
            String[] arry = columns.split(",");
            for (int i = 0; i < arry.length; ++i) {
                if (i != 0) {
                    sbcolumns.append(", ");
                }
                sbcolumns.append(arry[i]);
                sbcolumns.append(" AS ");
                sbcolumns.append(arry[i]);
                ++columnCount;
            }
        }
        final int finalcolumnCount = columnCount;
        sbcolumns.append(sb).append(this.appendSortSql(pageReq, order));
        final String hql = sbcolumns.toString();
        StringBuffer sbTotal = new StringBuffer("SELECT COUNT(*) ");
        sbTotal.append(sb);
        final String totalHql = sbTotal.toString();
        return (Page)this.getHibernateTemplate().execute(new HibernateCallback(){

            public Object doInHibernate(Session session) throws HibernateException {
                Iterator orParmiterator;
                Iterator parmiterator;
                org.hibernate.query.Query query = session.createQuery(hql);
                org.hibernate.query.Query totalQuery = session.createQuery(totalHql);
                int count = 0;
                Iterator iterator = parmiterator = parm == null ? null : parm.iterator();
                while (null != parmiterator && parmiterator.hasNext()) {
                    DaoCustomParm entry = (DaoCustomParm)parmiterator.next();
                    if ("do_eq".equals(entry.getDoType()) || "do_neq".equals(entry.getDoType())) {
                        if (null != entry.getParm()) {
                            query.setParameter("p_" + count + entry.getKey(), entry.getParm());
                            totalQuery.setParameter("p_" + count + entry.getKey(), entry.getParm());
                        }
                    } else if ("do_like".equals(entry.getDoType()) || "do_not_like".equals(entry.getDoType())) {
                        query.setParameter("p_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                        totalQuery.setParameter("p_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                    } else if ("do_in".equals(entry.getDoType()) || "do_notin".equals(entry.getDoType())) {
                        query.setParameterList("p_" + count + entry.getKey(), entry.getInParm());
                        totalQuery.setParameterList("p_" + count + entry.getKey(), entry.getInParm());
                    } else if ("do_date_lt".equals(entry.getDoType()) || "do_date_lte".equals(entry.getDoType()) || "do_date_gt".equals(entry.getDoType()) || "do_date_gte".equals(entry.getDoType())) {
                        query.setParameter("date_" + count + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                        totalQuery.setParameter("date_" + count + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                    } else if ("do_num_lt".equals(entry.getDoType()) || "do_num_lte".equals(entry.getDoType()) || "do_num_gt".equals(entry.getDoType()) || "do_num_gte".equals(entry.getDoType())) {
                        query.setParameter("number_" + count + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                        totalQuery.setParameter("number_" + count + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                    } else {
                        throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
                    }
                    ++count;
                }
                int orcount = 0;
                Iterator iterator2 = orParmiterator = orParm == null ? null : orParm.iterator();
                while (null != orParmiterator && orParmiterator.hasNext()) {
                    DaoCustomParm entry = (DaoCustomParm)orParmiterator.next();
                    if ("do_eq".equals(entry.getDoType()) || "do_neq".equals(entry.getDoType())) {
                        if (null != entry.getParm()) {
                            query.setParameter("or_" + orcount + entry.getKey(), entry.getParm());
                            totalQuery.setParameter("or_" + orcount + entry.getKey(), entry.getParm());
                        }
                    } else if ("do_like".equals(entry.getDoType()) || "do_not_like".equals(entry.getDoType())) {
                        query.setParameter("or_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                        totalQuery.setParameter("or_" + count + entry.getKey(), (Object)("%" + entry.getParm() + "%"));
                    } else if ("do_in".equals(entry.getDoType()) || "do_notin".equals(entry.getDoType())) {
                        query.setParameterList("or_" + orcount + entry.getKey(), entry.getInParm());
                        totalQuery.setParameterList("or_" + orcount + entry.getKey(), entry.getInParm());
                    } else if ("do_date_lt".equals(entry.getDoType()) || "do_date_lte".equals(entry.getDoType()) || "do_date_gt".equals(entry.getDoType()) || "do_date_gte".equals(entry.getDoType())) {
                        if (null == entry.getDateParm()) continue;
                        query.setParameter("or_date_" + orcount + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                        totalQuery.setParameter("or_date_" + orcount + entry.getKey(), (Object)entry.getDateParm(), entry.getType());
                    } else if ("do_num_lt".equals(entry.getDoType()) || "do_num_lte".equals(entry.getDoType()) || "do_num_gt".equals(entry.getDoType()) || "do_num_gte".equals(entry.getDoType())) {
                        if (null == entry.getDecimalParm()) continue;
                        query.setParameter("or_number_" + orcount + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                        totalQuery.setParameter("or_number_" + orcount + entry.getKey(), (Object)entry.getDecimalParm(), (Type)StandardBasicTypes.BIG_DECIMAL);
                    } else {
                        throw new BusinessException("\u5f53\u524d\u4e0d\u652f\u6301\u8be5\u67e5\u8be2\u65b9\u5f0f", (Throwable)new NotSupportedException());
                    }
                    ++orcount;
                }
                if (isSeraceColumn && finalcolumnCount != 1) {
                    query.setResultTransformer((ResultTransformer)Transformers.ALIAS_TO_ENTITY_MAP);
                }
                BaseHibernateDao.agParmSet(pageReq, (Query)query, (Query)totalQuery);
                return PageQueryUtils.executeQueryForPage((PageRequest)pageReq, (Query)query, (Query)totalQuery);
            }
        });
    }
}

