/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.utils;

import com.kotelmems.platform.page.Page;
import com.kotelmems.platform.page.PageRequest;
import com.kotelmems.platform.util.PageQueryUtils;
import com.kotelmems.platform.xsqlbuilder.XsqlBuilder;
import java.util.List;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.Session;
import org.springframework.orm.hibernate5.HibernateCallback;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class HibernateTemplateUtil {
    private HibernateTemplate hibernateTemplate;

    public void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
        this.hibernateTemplate = hibernateTemplate;
    }

    public HibernateTemplate getHibernateTemplate() {
        return this.hibernateTemplate;
    }

    public List<?> queryHqlForList(String sql, final Map<?, ?> parameters) {
        final String hql = this.convertSql(sql, parameters);
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createQuery(hql), (Map)parameters);
                return query.list();
            }
        });
    }

    public Page<?> queryHqlForPage(String sql, Map<?, ?> parameters, PageRequest pageRequest) {
        String hql = this.convertSql(sql, parameters);
        String countHql = PageQueryUtils.createCountSql((String)hql);
        return PageQueryUtils.pageQuery((HibernateTemplate)this.getHibernateTemplate(), (String)hql, (String)countHql, (PageRequest)pageRequest, parameters);
    }

    public List<?> querySqlForList(String sql, final Map<?, ?> parameters) {
        final String c_sql = this.convertSql(sql, parameters);
        return (List)this.getHibernateTemplate().execute(new HibernateCallback<List<?>>(){

            public List<?> doInHibernate(Session session) throws HibernateException {
                Query query = PageQueryUtils.setQueryParameters((Query)session.createSQLQuery(c_sql), (Map)parameters);
                return query.list();
            }
        });
    }

    public Page<?> querySqlForPage(String sql, Map<?, ?> parameters, PageRequest pageRequest) {
        String c_sql = this.convertSql(sql, parameters);
        String countSql = PageQueryUtils.createCountSql((String)c_sql);
        return PageQueryUtils.pageSQLQuery((HibernateTemplate)this.getHibernateTemplate(), (String)c_sql, (String)countSql, (PageRequest)pageRequest, parameters);
    }

    private String convertSql(String sql, Map<?, ?> parameters) {
        XsqlBuilder.XsqlFilterResult xsqlRes = new XsqlBuilder().generateHql(sql, parameters);
        return xsqlRes.getXsql();
    }
}

