/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Validation {
    private static final Logger LOGGER = LoggerFactory.getLogger(Validation.class);
    private static final String P_INT = "^\\d+$";
    private static final String P_FLOAT = "^\\d+(\\.\\d+){0,1}$";
    private static final String P_PHONE = "^1[3|4|5|6|7|8|9][0-9]\\d{4,8}$";
    private static final String P_EMAIL = "^[a-z0-9A-Z]+[- | a-z0-9A-Z . _]+@([a-z0-9A-Z]+(-[a-z0-9A-Z]+)?\\.)+[a-z]{2,}$";
    public static final int INT = 1;
    public static final int FLOAT = 2;
    public static final int PHONE = 3;
    public static final int EMAIL = 4;

    public static void main(String[] args) {
    }

    public static boolean validate(String input, int matcher) {
        if (Validation.isNULL(input).booleanValue()) {
            return false;
        }
        String regex = null;
        switch (matcher) {
            case 1: {
                regex = P_INT;
                break;
            }
            case 2: {
                regex = P_FLOAT;
                break;
            }
            case 3: {
                regex = P_PHONE;
                break;
            }
            case 4: {
                regex = P_EMAIL;
                break;
            }
            default: {
                return false;
            }
        }
        return Pattern.matches(regex, input);
    }

    public static String toString(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return "";
        }
        return value.toString().trim();
    }

    public static String isNbsp(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return "&nbsp;";
        }
        return value.toString();
    }

    public static Boolean isNULL(Object ... value) {
        if (value == null || value.length < 1) {
            return true;
        }
        int i = 0;
        while (i < value.length) {
            if (value[i] == null || "".equals(value[i].toString()) || "null".equals(value[i].toString().toLowerCase())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String toNumber(String format, Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return "";
        }
        DecimalFormat df = new DecimalFormat(format);
        StringBuffer sb = new StringBuffer();
        df.format((Object)new BigDecimal(value.toString()), sb, new FieldPosition(0));
        return sb.toString();
    }

    public static Boolean equals(Object o, Object x) {
        if (Validation.isNULL(o).booleanValue() || Validation.isNULL(x).booleanValue()) {
            return false;
        }
        if (o == x || o.equals(x) || o.toString().equals(x)) {
            return true;
        }
        return false;
    }

    public static Float toFloat(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return Float.valueOf(0.0f);
        }
        return Float.valueOf(Float.parseFloat(value.toString()));
    }

    public static Boolean isBoolean(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return false;
        }
        if (value.toString().equals("0") || value.toString().equalsIgnoreCase("false")) {
            return false;
        }
        return true;
    }

    public static Integer toInteger(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return 0;
        }
        return Integer.parseInt(value.toString());
    }

    public static Long toLong(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return 0L;
        }
        return Long.parseLong(value.toString());
    }

    public static Double toDouble(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return 0.0;
        }
        return Double.parseDouble(value.toString());
    }

    public static Boolean toBoolean(Object value) {
        if (Validation.isNULL(value).booleanValue()) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public static String toTrim(String str) {
        String s = "";
        if (str != null) {
            s = str.trim();
        }
        return s;
    }

    public static boolean isDate(Object value) {
        return Validation.isDateFormat(value, "^\\d{4}-\\d{1,2}-\\d{1,2}$");
    }

    public static boolean isDateTime(Object value) {
        return Validation.isDateFormat(value, "^\\d{4}-\\d{2}-\\d{2} \\d{2}:\\d{2}:\\d{2}$");
    }

    public static boolean isDateFormat(Object value, String fromatReg) {
        Pattern pattern = Pattern.compile(fromatReg);
        return Validation.isNULL(value) == false && pattern.matcher(value.toString()).matches();
    }

    public static String toDay(String format) {
        if (Validation.isNULL(format).booleanValue()) {
            return new SimpleDateFormat(format).format(new Date());
        }
        return new SimpleDateFormat(format).format(new Date());
    }

    public static String getCode(int mnum) {
        char[] strRandom = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        StringBuffer finalStr = new StringBuffer();
        int count = 0;
        while (count < mnum) {
            int randomNum = new Random().nextInt(62);
            finalStr.append(strRandom[randomNum]);
            ++count;
        }
        return finalStr.toString();
    }

    public static String[][] toArray(String x) {
        String[] xx = x.split("=!=");
        String[][] xxx = new String[xx.length][];
        int i = 0;
        while (i < xx.length) {
            xxx[i] = xx[i].split("-!-");
            ++i;
        }
        return xxx;
    }

    public static Object[] toByte(Object value) {
        return null;
    }

    public static Object[] toTime(Object value) {
        return null;
    }
}

