/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.component.json.impl;

import com.kotelmems.platform.component.json.JsonManager;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import net.sf.ezmorph.Morpher;
import net.sf.ezmorph.object.DateMorpher;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JsonConfig;
import net.sf.json.processors.JsonValueProcessor;
import net.sf.json.util.JSONUtils;

public class JsonManagerByJsonlibImpl
implements JsonManager {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    static {
        String[] dateFormats = new String[]{DATE_TIME_FORMAT, TIME_FORMAT, DATE_FORMAT};
        JSONUtils.getMorpherRegistry().registerMorpher((Morpher)new DateMorpher(dateFormats));
    }

    @Override
    public Map<?, ?> fromJson(String jsonString) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        return jsonObject;
    }

    @Override
    public <T> T fromJson(String jsonString, Class<T> objectClass) {
        JSONObject jsonObject = JSONObject.fromObject((Object)jsonString);
        Object pojo = JSONObject.toBean((JSONObject)jsonObject, objectClass);
        return (T)pojo;
    }

    @Override
    public List<?> fromJsonToList(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return jsonArray;
    }

    @Override
    public <T> List<T> fromJsonToList(String jsonString, Class<T> objectClass) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return JSONArray.toList((JSONArray)jsonArray, objectClass);
    }

    @Override
    public <T> Collection<T> jsonToCollection(String jsonString, Class<T> objectClass) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return JSONArray.toCollection((JSONArray)jsonArray, objectClass);
    }

    @Override
    public Object[] jsonToArray(String jsonString) {
        JSONArray jsonArray = JSONArray.fromObject((Object)jsonString);
        return (Object[])JSONArray.toArray((JSONArray)jsonArray);
    }

    @Override
    public String toJson(Object bean) {
        JSONObject json = JSONObject.fromObject((Object)bean, (JsonConfig)JsonManagerByJsonlibImpl.configJson());
        return json.toString();
    }

    public String toJsonList(Collection collection) {
        JSONArray json = JSONArray.fromObject((Object)collection, (JsonConfig)JsonManagerByJsonlibImpl.configJson());
        return json.toString();
    }

    private static JsonConfig configJson() {
        JsonConfig jsonConfig = new JsonConfig();
        jsonConfig.registerJsonValueProcessor(Date.class, (JsonValueProcessor)new JsonValueProcessorImpl());
        jsonConfig.registerJsonValueProcessor(java.sql.Date.class, (JsonValueProcessor)new JsonValueProcessorImpl());
        jsonConfig.registerJsonValueProcessor(Timestamp.class, (JsonValueProcessor)new JsonValueProcessorImpl());
        jsonConfig.registerJsonValueProcessor(Calendar.class, (JsonValueProcessor)new JsonValueProcessorImpl());
        return jsonConfig;
    }

    static class JsonValueProcessorImpl
    implements JsonValueProcessor {
        JsonValueProcessorImpl() {
        }

        public Object processArrayValue(Object values, JsonConfig arg1) {
            int i;
            Comparable<Date>[] valuesObj;
            SimpleDateFormat sf;
            if (values == null) {
                return null;
            }
            String[] obj = null;
            if (values instanceof Date[]) {
                sf = new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT);
                valuesObj = (Date[])values;
                obj = new String[valuesObj.length];
                i = 0;
                while (i < valuesObj.length) {
                    obj[i] = sf.format((Date)valuesObj[i]);
                    ++i;
                }
            }
            if (values instanceof java.sql.Date[]) {
                sf = new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_FORMAT);
                valuesObj = (java.sql.Date[])values;
                obj = new String[valuesObj.length];
                i = 0;
                while (i < valuesObj.length) {
                    obj[i] = sf.format((Date)valuesObj[i]);
                    ++i;
                }
            }
            if (values instanceof Timestamp[]) {
                sf = new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT);
                valuesObj = (Timestamp[])values;
                obj = new String[valuesObj.length];
                i = 0;
                while (i < valuesObj.length) {
                    obj[i] = sf.format((Date)valuesObj[i]);
                    ++i;
                }
            }
            if (values instanceof Calendar[]) {
                sf = new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT);
                valuesObj = (Calendar[])values;
                obj = new String[valuesObj.length];
                i = 0;
                while (i < valuesObj.length) {
                    obj[i] = sf.format(((Calendar)valuesObj[i]).getTime());
                    ++i;
                }
            }
            return obj;
        }

        public Object processObjectValue(String key, Object value, JsonConfig config) {
            if (value == null) {
                return null;
            }
            if (value instanceof Date) {
                return new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT).format((Date)value);
            }
            if (value instanceof java.sql.Date) {
                return new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_FORMAT).format((java.sql.Date)value);
            }
            if (value instanceof Timestamp) {
                String str = new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT).format((Timestamp)value);
                return str;
            }
            if (value instanceof Calendar) {
                Date date = ((Calendar)value).getTime();
                return new SimpleDateFormat(JsonManagerByJsonlibImpl.DATE_TIME_FORMAT).format(date);
            }
            return value.toString();
        }
    }
}

