/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.MappingException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class JavaEnumLoader
implements EnumLoader {
    private static final String RESOURCE_PATTERN = "/**/*.class";
    private ResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
    private String[] packagesToScan;
    private List<Class<?>> enumClasses = new ArrayList();

    public void setPackagesToScan(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    public JavaEnumLoader() {
    }

    public JavaEnumLoader(String ... packagesToScan) {
        this.packagesToScan = packagesToScan;
    }

    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        if (this.enumClasses.isEmpty()) {
            this.initEnumClass();
        }
        for (Class<?> clazz : this.enumClasses) {
            if (!clazz.isEnum()) continue;
            Method method = null;
            EnumItem[] enums = null;
            try {
                method = clazz.getMethod("values", new Class[0]);
                enums = (EnumItem[])method.invoke(null, null);
            }
            catch (NoSuchMethodException e1) {
                e1.printStackTrace();
            }
            catch (SecurityException e1) {
                e1.printStackTrace();
            }
            catch (IllegalAccessException e1) {
                e1.printStackTrace();
            }
            catch (IllegalArgumentException e1) {
                e1.printStackTrace();
            }
            catch (InvocationTargetException e1) {
                e1.printStackTrace();
            }
            EnumItem[] enumItemArray = enums;
            int n = enums.length;
            int n2 = 0;
            while (n2 < n) {
                List<EnumItem> ets;
                EnumItem e = enumItemArray[n2];
                String key = e.getType();
                if (!result.containsKey(key)) {
                    ets = new ArrayList<EnumItem>();
                    ets.add(e);
                    result.put(key, ets);
                } else {
                    ets = (List)result.get(key);
                    ets.add(e);
                }
                ++n2;
            }
        }
        return result;
    }

    private boolean isImplementEnumItemInterface(Class<?> clazz) {
        Class<?>[] classArray = clazz.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> face = classArray[n2];
            if (face.equals(EnumItem.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void initEnumClass() {
        try {
            String[] stringArray = this.packagesToScan;
            int n = this.packagesToScan.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)pkg) + RESOURCE_PATTERN;
                Resource[] resources = this.resourcePatternResolver.getResources(pattern);
                CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)this.resourcePatternResolver);
                Resource[] resourceArray = resources;
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    Resource resource = resourceArray[n4];
                    if (resource.isReadable()) {
                        MetadataReader reader = readerFactory.getMetadataReader(resource);
                        String className = reader.getClassMetadata().getClassName();
                        Class<?> clazz = this.resourcePatternResolver.getClassLoader().loadClass(className);
                        clazz.getInterfaces();
                        if (clazz.isEnum() && this.isImplementEnumItemInterface(clazz)) {
                            this.enumClasses.add(clazz);
                        }
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (IOException ex) {
            throw new MappingException("Failed to scan classpath for unlisted classes", (Throwable)ex);
        }
        catch (ClassNotFoundException ex) {
            throw new MappingException("Failed to load annotated classes from classpath", (Throwable)ex);
        }
    }
}

