/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.xsqlbuilder;

import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

class MapAndObject
implements Map {
    Map map;
    Object bean;

    public MapAndObject(Map map, Object bean) {
        this.map = map;
        this.bean = bean;
    }

    public Map getMap() {
        return this.map;
    }

    public Object getBean() {
        return this.bean;
    }

    public Object get(Object key) {
        return this.getFromMapOrBean(key);
    }

    Object getFromMapOrBean(Object key) {
        Object result = null;
        if (this.map != null) {
            result = this.map.get(key);
        }
        if (result == null && this.bean instanceof Map) {
            return ((Map)this.bean).get(key);
        }
        if (result == null && this.bean != null && key instanceof String) {
            String propertyName = (String)key;
            return FastPropertyUtils.getBeanPropertyValue(this.bean, propertyName);
        }
        return result;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    public Set entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException();
    }

    public Set keySet() {
        throw new UnsupportedOperationException();
    }

    public Object put(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    public void putAll(Map m) {
        throw new UnsupportedOperationException();
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException();
    }

    public Collection values() {
        throw new UnsupportedOperationException();
    }

    static class FastPropertyUtils {
        private static Map beanInfoCache = Collections.synchronizedMap(new WeakHashMap());

        FastPropertyUtils() {
        }

        static Object getBeanPropertyValue(Object bean, String propertyName) {
            PropertyDescriptor pd;
            block7: {
                if (bean == null) {
                    throw new IllegalArgumentException("bean cannot be not null");
                }
                if (propertyName == null) {
                    throw new IllegalArgumentException("propertyName cannot be not null");
                }
                ExtendBeanInfo beanInfo = FastPropertyUtils.getBeanInfo(bean.getClass());
                pd = beanInfo.getPropertyDescriptor(propertyName);
                if (pd != null && pd.getReadMethod() != null) break block7;
                return null;
            }
            try {
                return pd.getReadMethod().invoke(bean, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("cannot get property value by property:" + propertyName + " on class:" + bean.getClass(), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("cannot get property value by property:" + propertyName + " on class:" + bean.getClass(), e);
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("cannot get property value by property:" + propertyName + " on class:" + bean.getClass(), e);
            }
        }

        private static ExtendBeanInfo getBeanInfo(Class clazz) throws IntrospectionException {
            ExtendBeanInfo beanInfo = (ExtendBeanInfo)beanInfoCache.get(clazz);
            if (beanInfo == null) {
                beanInfo = new ExtendBeanInfo(Introspector.getBeanInfo(clazz));
                beanInfoCache.put(clazz, beanInfo);
            }
            return beanInfo;
        }

        private static class ExtendBeanInfo
        implements BeanInfo {
            BeanInfo delegate;
            private Map propertyDescriptorCache = Collections.synchronizedMap(new WeakHashMap());

            public ExtendBeanInfo(BeanInfo delegate) {
                this.delegate = delegate;
            }

            @Override
            public BeanInfo[] getAdditionalBeanInfo() {
                return this.delegate.getAdditionalBeanInfo();
            }

            @Override
            public BeanDescriptor getBeanDescriptor() {
                return this.delegate.getBeanDescriptor();
            }

            @Override
            public int getDefaultEventIndex() {
                return this.delegate.getDefaultEventIndex();
            }

            @Override
            public int getDefaultPropertyIndex() {
                return this.delegate.getDefaultPropertyIndex();
            }

            @Override
            public EventSetDescriptor[] getEventSetDescriptors() {
                return this.delegate.getEventSetDescriptors();
            }

            @Override
            public Image getIcon(int iconKind) {
                return this.delegate.getIcon(iconKind);
            }

            @Override
            public MethodDescriptor[] getMethodDescriptors() {
                return this.delegate.getMethodDescriptors();
            }

            @Override
            public PropertyDescriptor[] getPropertyDescriptors() {
                return this.delegate.getPropertyDescriptors();
            }

            public PropertyDescriptor getPropertyDescriptor(String name) {
                if (this.propertyDescriptorCache.containsKey(name)) {
                    return (PropertyDescriptor)this.propertyDescriptorCache.get(name);
                }
                PropertyDescriptor pd = this.getPropertyDescriptorFromArray(name);
                this.propertyDescriptorCache.put(name, pd);
                return pd;
            }

            private PropertyDescriptor getPropertyDescriptorFromArray(String name) {
                PropertyDescriptor pd = null;
                PropertyDescriptor[] propertyDescriptors = this.getPropertyDescriptors();
                int i = 0;
                while (i < propertyDescriptors.length) {
                    PropertyDescriptor temp = propertyDescriptors[i];
                    if (temp.getName().equals(name)) {
                        pd = propertyDescriptors[i];
                    }
                    ++i;
                }
                return pd;
            }
        }
    }
}

