/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.xsqlbuilder.datamodifier;

import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.DataModifierBean;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.BigDecimalDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.BigIntegerDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.BooleanDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.ByteDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.DateDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.DefaultDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.DoubleDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.FloatDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.IntegerDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.LongDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.ShortDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.SqlDateDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.SqlTimeDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.StringDataModifier;
import com.kotelmems.platform.xsqlbuilder.datamodifier.modifier.TimestampDataModifier;
import java.util.Map;

public class DataModifierUtils {
    private static DataModifierBean delegate = new DataModifierBean();

    static {
        DataModifierUtils.registerDefaultDataModifiers(delegate);
    }

    private DataModifierUtils() {
    }

    public static void registerDefaultDataModifiers(DataModifierBean bean) {
        bean.registerDataModifier("default", new DefaultDataModifier());
        bean.registerDataModifier("boolean", new BooleanDataModifier());
        bean.registerDataModifier("string", new StringDataModifier());
        bean.registerDataModifier("byte", new ByteDataModifier());
        bean.registerDataModifier("short", new ShortDataModifier());
        bean.registerDataModifier("int", new IntegerDataModifier());
        bean.registerDataModifier("long", new LongDataModifier());
        bean.registerDataModifier("float", new FloatDataModifier());
        bean.registerDataModifier("double", new DoubleDataModifier());
        bean.registerDataModifier("BigInteger", new BigIntegerDataModifier());
        bean.registerDataModifier("BigDecimal", new BigDecimalDataModifier());
        bean.registerDataModifier("date", new DateDataModifier());
        bean.registerDataModifier("sqldate", new SqlDateDataModifier());
        bean.registerDataModifier("sqltime", new SqlTimeDataModifier());
        bean.registerDataModifier("timestamp", new TimestampDataModifier());
    }

    public static void deregisterDataModifier(String modifierName) {
        delegate.deregisterDataModifier(modifierName);
    }

    public static void registerDataModifier(String modifierName, DataModifier modifier) {
        delegate.registerDataModifier(modifierName, modifier);
    }

    public Map getAvailableDataModifiers() {
        return delegate.getAvailableDataModifiers();
    }

    public static Object directModify(String dataModifierExpression, Object dataModifyValue) {
        return delegate.directModify(dataModifierExpression, dataModifyValue);
    }

    public static Object modify(String completeExpression, Object dataModifyValue) {
        return delegate.modify(completeExpression, dataModifyValue);
    }

    public static String getModifyVariable(String completeExpression) {
        return DataModifierBean.getModifyVariable(completeExpression);
    }
}

