/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class ApiRequest {
    @Value(value="${xpm.v3.server.url}")
    private String baseUrl;
    private String apiUrl;
    private CloseableHttpClient httpClient;

    public ApiRequest() {
        this.apiUrl = this.baseUrl + "/apiV3";
        this.httpClient = HttpClients.createDefault();
    }

    public String publicRequestApi(String userCode, String password) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + "/login/getToken");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("userCode", userCode));
            params.add(new BasicNameValuePair("password", password));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String apiPostRequest(String token, String url, List<NameValuePair> params) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + url);
            httpPost.setHeader("Authorization", token);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            if (!CollectionUtils.isEmpty(params)) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String apiPostRequest(String token, String url, String body) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + url);
            httpPost.setHeader("Authorization", token);
            httpPost.addHeader("Content-Type", "application/json");
            if (StringUtils.isNotEmpty((CharSequence)body)) {
                httpPost.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String apiGetRequest(String token, String url) {
        try {
            HttpGet httpGet = new HttpGet(this.apiUrl + url);
            httpGet.setHeader("Authorization", token);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            return EntityUtils.toString((HttpEntity)response.getEntity());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

