/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.redis;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;

public class BaseRedisTemplate<T> {
    protected RedisTemplate<String, T> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, T> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public boolean set(String key, T value) {
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            return true;
        }
        catch (Exception var5) {
            var5.printStackTrace();
            return false;
        }
    }

    public boolean set(String key, T value, Long expireTime) {
        boolean result = false;
        try {
            ValueOperations operations = this.redisTemplate.opsForValue();
            operations.set((Object)key, value);
            this.redisTemplate.expire((Object)key, expireTime.longValue(), TimeUnit.SECONDS);
            result = true;
        }
        catch (Exception var6) {
            var6.printStackTrace();
        }
        return result;
    }

    public boolean exists(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public void remove(String key) {
        if (this.exists(key)) {
            this.redisTemplate.delete((Object)key);
        }
    }

    public void remove(String ... keys) {
        String[] var2 = keys;
        int var3 = keys.length;
        for (int var4 = 0; var4 < var3; ++var4) {
            String key = var2[var4];
            this.remove(key);
        }
    }

    public void removePattern(String prefix) {
        Set keys = this.redisTemplate.keys((Object)prefix);
        if (keys.size() > 0) {
            this.redisTemplate.delete((Collection)keys);
        }
    }

    public Set<String> getKeys(String prefix) {
        Set keys = this.redisTemplate.keys((Object)prefix);
        return keys;
    }

    public T get(String key) {
        Object result = null;
        ValueOperations operations = this.redisTemplate.opsForValue();
        result = operations.get((Object)key);
        return (T)result;
    }

    public void hmSet(String key, String hashKey, T value) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.put((Object)key, (Object)hashKey, value);
    }

    public T hmGet(String key, String hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return (T)hash.get((Object)key, (Object)hashKey);
    }

    public Set<String> hmKeys(String key) {
        HashOperations hash = this.redisTemplate.opsForHash();
        return hash.keys((Object)key);
    }

    public void hmDel(String masterKey, Object ... hashKey) {
        HashOperations hash = this.redisTemplate.opsForHash();
        hash.delete((Object)masterKey, hashKey);
    }

    public void lPush(String k, T v) {
        ListOperations list = this.redisTemplate.opsForList();
        list.rightPush((Object)k, v);
    }

    public List<T> lRange(String k, long l, long l1) {
        ListOperations list = this.redisTemplate.opsForList();
        return list.range((Object)k, l, l1);
    }

    public void add(String key, T[] value) {
        SetOperations set = this.redisTemplate.opsForSet();
        set.add((Object)key, (Object[])value);
    }

    public Set<T> setMembers(String key) {
        SetOperations set = this.redisTemplate.opsForSet();
        return set.members((Object)key);
    }

    public void zAdd(String key, T value, double scoure) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        zset.add((Object)key, value, scoure);
    }

    public Set<T> rangeByScore(String key, double scoure, double scoure1) {
        ZSetOperations zset = this.redisTemplate.opsForZSet();
        return zset.rangeByScore((Object)key, scoure, scoure1);
    }

    public T lPop(String k) {
        ListOperations list = this.redisTemplate.opsForList();
        return (T)list.leftPop((Object)k);
    }

    public boolean expire(String key, long timeout) {
        return this.redisTemplate.expire((Object)key, timeout, TimeUnit.SECONDS);
    }

    public long ttl(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public void convertAndSend(String channel, T message) {
        this.redisTemplate.convertAndSend(channel, message);
    }
}

