/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import cn.hutool.core.io.IoUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.minio.BaseArgs;
import io.minio.BucketExistsArgs;
import io.minio.CloseableIterator;
import io.minio.ComposeObjectArgs;
import io.minio.ComposeSource;
import io.minio.CopyObjectArgs;
import io.minio.CopySource;
import io.minio.DeleteBucketEncryptionArgs;
import io.minio.DeleteBucketLifecycleArgs;
import io.minio.DeleteBucketNotificationArgs;
import io.minio.DeleteBucketPolicyArgs;
import io.minio.DeleteBucketReplicationArgs;
import io.minio.DeleteBucketTagsArgs;
import io.minio.DeleteObjectTagsArgs;
import io.minio.DisableObjectLegalHoldArgs;
import io.minio.DownloadObjectArgs;
import io.minio.EnableObjectLegalHoldArgs;
import io.minio.GetBucketEncryptionArgs;
import io.minio.GetBucketLifecycleArgs;
import io.minio.GetBucketNotificationArgs;
import io.minio.GetBucketPolicyArgs;
import io.minio.GetBucketReplicationArgs;
import io.minio.GetBucketTagsArgs;
import io.minio.GetBucketVersioningArgs;
import io.minio.GetObjectArgs;
import io.minio.GetObjectLockConfigurationArgs;
import io.minio.GetObjectRetentionArgs;
import io.minio.GetObjectTagsArgs;
import io.minio.GetPresignedObjectUrlArgs;
import io.minio.IsObjectLegalHoldEnabledArgs;
import io.minio.ListObjectsArgs;
import io.minio.ListenBucketNotificationArgs;
import io.minio.MakeBucketArgs;
import io.minio.MinioClient;
import io.minio.ObjectWriteResponse;
import io.minio.PutObjectArgs;
import io.minio.RemoveBucketArgs;
import io.minio.RemoveObjectArgs;
import io.minio.RestoreObjectArgs;
import io.minio.Result;
import io.minio.ServerSideEncryption;
import io.minio.ServerSideEncryptionCustomerKey;
import io.minio.SetBucketEncryptionArgs;
import io.minio.SetBucketLifecycleArgs;
import io.minio.SetBucketNotificationArgs;
import io.minio.SetBucketPolicyArgs;
import io.minio.SetBucketReplicationArgs;
import io.minio.SetBucketTagsArgs;
import io.minio.SetBucketVersioningArgs;
import io.minio.SetObjectLockConfigurationArgs;
import io.minio.SetObjectRetentionArgs;
import io.minio.SetObjectTagsArgs;
import io.minio.SnowballObject;
import io.minio.StatObjectArgs;
import io.minio.StatObjectResponse;
import io.minio.Time;
import io.minio.UploadObjectArgs;
import io.minio.UploadSnowballObjectsArgs;
import io.minio.http.Method;
import io.minio.messages.AndOperator;
import io.minio.messages.Bucket;
import io.minio.messages.DeleteMarkerReplication;
import io.minio.messages.Event;
import io.minio.messages.EventType;
import io.minio.messages.Expiration;
import io.minio.messages.Item;
import io.minio.messages.LifecycleConfiguration;
import io.minio.messages.LifecycleRule;
import io.minio.messages.NotificationConfiguration;
import io.minio.messages.NotificationRecords;
import io.minio.messages.ObjectLockConfiguration;
import io.minio.messages.QueueConfiguration;
import io.minio.messages.ReplicationConfiguration;
import io.minio.messages.ReplicationDestination;
import io.minio.messages.ReplicationRule;
import io.minio.messages.RestoreRequest;
import io.minio.messages.Retention;
import io.minio.messages.RetentionDuration;
import io.minio.messages.RetentionDurationDays;
import io.minio.messages.RetentionMode;
import io.minio.messages.RuleFilter;
import io.minio.messages.SseAlgorithm;
import io.minio.messages.SseConfiguration;
import io.minio.messages.Status;
import io.minio.messages.Tags;
import io.minio.messages.VersioningConfiguration;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import javax.crypto.KeyGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class MinioUtils {
    private static final Logger log = LoggerFactory.getLogger(MinioUtils.class);
    private static MinioClient minioClient;
    private static boolean enable;
    private static String endpoint;
    private static String bucketName;
    private static String accessKey;
    private static String secretKey;
    private static final String SEPARATOR = "/";

    public static synchronized void initMinioConf() {
        InputStream stream = null;
        try {
            Properties minioProperties = new Properties();
            stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("application.properties");
            InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
            minioProperties.load(reader);
            stream.close();
            reader.close();
            endpoint = minioProperties.getProperty("minio.endpoint");
            bucketName = minioProperties.getProperty("minio.bucketName");
            accessKey = minioProperties.getProperty("minio.accessKey");
            secretKey = minioProperties.getProperty("minio.secretKey");
            enable = "true".equalsIgnoreCase(minioProperties.getProperty("minio.enable"));
        }
        catch (IOException e) {
            try {
                log.error("\u521d\u59cb\u5316Minio\u4fe1\u606f\u51fa\u9519\uff01");
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtil.close(stream);
                IoUtil.close(stream);
                throw throwable;
            }
            IoUtil.close((Closeable)stream);
            IoUtil.close((Closeable)stream);
        }
        IoUtil.close((Closeable)stream);
        IoUtil.close((Closeable)stream);
    }

    private MinioUtils() {
        MinioUtils.createMinioClient();
    }

    public MinioUtils(String endpoint, String bucketName, String accessKey, String secretKey) {
        MinioUtils.endpoint = endpoint;
        MinioUtils.bucketName = bucketName;
        MinioUtils.accessKey = accessKey;
        MinioUtils.secretKey = secretKey;
        MinioUtils.createMinioClient();
    }

    public static boolean isEnable() {
        return enable;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void createMinioClient() {
        try {
            log.info("Minio enable is:{}", (Object)enable);
            if (enable && null == minioClient) {
                MinioUtils.initMinioConf();
                log.info("minioClient create start");
                minioClient = MinioClient.builder().endpoint(endpoint).credentials(accessKey, secretKey).build();
                MinioUtils.createBucket();
                log.info("minioClient create end");
            }
        }
        catch (Exception e) {
            log.error("\u8fde\u63a5MinIO\u670d\u52a1\u5668\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
        }
    }

    public static String getBasisUrl() {
        return endpoint + SEPARATOR + bucketName + SEPARATOR;
    }

    private static void createBucket() throws Exception {
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
    }

    public static void createBucket(String bucketName) throws Exception {
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketName)).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketName)).build());
        }
    }

    public static List<Bucket> getAllBuckets() throws Exception {
        return minioClient.listBuckets();
    }

    public static Optional<Bucket> getBucket(String bucketName) throws Exception {
        return minioClient.listBuckets().stream().filter(b -> b.name().equals(bucketName)).findFirst();
    }

    public static void removeBucket(String bucketName) throws Exception {
        minioClient.removeBucket((RemoveBucketArgs)((RemoveBucketArgs.Builder)RemoveBucketArgs.builder().bucket(bucketName)).build());
    }

    public static JSONObject getBucketPolicy(String bucketName) throws Exception {
        String bucketPolicy = minioClient.getBucketPolicy((GetBucketPolicyArgs)((GetBucketPolicyArgs.Builder)GetBucketPolicyArgs.builder().bucket(bucketName)).build());
        return JSONObject.parseObject((String)bucketPolicy);
    }

    public static void setBucketPolicy(String bucketName, JSONObject prolicy) throws Exception {
        minioClient.setBucketPolicy((SetBucketPolicyArgs)((SetBucketPolicyArgs.Builder)SetBucketPolicyArgs.builder().bucket(bucketName)).config(prolicy.toJSONString()).build());
    }

    public static void deleteBucketPolicy(String bucketName) throws Exception {
        minioClient.deleteBucketPolicy((DeleteBucketPolicyArgs)((DeleteBucketPolicyArgs.Builder)DeleteBucketPolicyArgs.builder().bucket(bucketName)).build());
        log.info("Bucket policy is deleted successfully");
    }

    public static boolean doesObjectExist(String bucketName, String objectName) {
        boolean exist = true;
        try {
            minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
        }
        catch (Exception e) {
            exist = false;
        }
        return exist;
    }

    public static boolean doesFolderExist(String bucketName, String objectName) {
        boolean exist = false;
        try {
            Iterable results = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(objectName).recursive(false).build());
            for (Result result : results) {
                Item item = (Item)result.get();
                if (!item.isDir() || !objectName.equals(item.objectName())) continue;
                exist = true;
            }
        }
        catch (Exception e) {
            exist = false;
        }
        return exist;
    }

    public static List<Item> getAllObjectsByPrefix(String bucketName, String prefix, boolean recursive) throws Exception {
        ArrayList<Item> list = new ArrayList<Item>();
        Iterable objectsIterator = minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).build());
        if (objectsIterator != null) {
            for (Result o : objectsIterator) {
                Item item = (Item)o.get();
                list.add(item);
            }
        }
        return list;
    }

    public static InputStream getObject(String bucketName, String objectName) throws Exception {
        return minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public static void downloadObject(String bucketname, String objectname, String filename, boolean ssec) throws Exception {
        if (!ssec) {
            minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketname)).object(objectname)).filename(filename).build());
            return;
        }
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        ServerSideEncryptionCustomerKey sseck = new ServerSideEncryptionCustomerKey(keyGen.generateKey());
        minioClient.downloadObject((DownloadObjectArgs)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)((DownloadObjectArgs.Builder)DownloadObjectArgs.builder().bucket(bucketname)).object(objectname)).filename(filename).ssec(sseck)).build());
    }

    public InputStream getObject(String bucketName, String objectName, long offset, long length) throws Exception {
        return minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(bucketName)).object(objectName)).offset(Long.valueOf(offset))).length(Long.valueOf(length))).build());
    }

    public static Iterable<Result<Item>> listObjects(String bucketName, String prefix, boolean recursive) {
        return minioClient.listObjects((ListObjectsArgs)((ListObjectsArgs.Builder)ListObjectsArgs.builder().bucket(bucketName)).prefix(prefix).recursive(recursive).build());
    }

    public static ObjectWriteResponse putObject(String bucketName, MultipartFile file, String objectName, String contentType) throws Exception {
        InputStream inputStream = file.getInputStream();
        return minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).contentType(contentType).stream(inputStream, (long)inputStream.available(), -1L).build());
    }

    public static ObjectWriteResponse uploadObject(String bucketName, String objectName, String fileName, boolean ssec) throws Exception {
        if (!ssec) {
            return minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).build());
        }
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(256);
        ServerSideEncryptionCustomerKey sseck = new ServerSideEncryptionCustomerKey(keyGen.generateKey());
        return minioClient.uploadObject((UploadObjectArgs)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)((UploadObjectArgs.Builder)UploadObjectArgs.builder().bucket(bucketName)).object(objectName)).filename(fileName).sse((ServerSideEncryption)sseck)).build());
    }

    public static ObjectWriteResponse uploadObject(String bucketName, String objectName, InputStream inputStream) throws Exception {
        return minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream(inputStream, (long)inputStream.available(), -1L).build());
    }

    public static ObjectWriteResponse putDirObject(String bucketName, String objectName) throws Exception {
        return minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(bucketName)).object(objectName)).stream((InputStream)new ByteArrayInputStream(new byte[0]), 0L, -1L).build());
    }

    public static StatObjectResponse statObject(String bucketName, String objectName) throws Exception {
        return minioClient.statObject((StatObjectArgs)((StatObjectArgs.Builder)((StatObjectArgs.Builder)StatObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public static ObjectWriteResponse copyObject(String bucketName, String objectName, String srcBucketName, String srcObjectName) throws Exception {
        return minioClient.copyObject((CopyObjectArgs)((CopyObjectArgs.Builder)((CopyObjectArgs.Builder)CopyObjectArgs.builder().source((CopySource)((CopySource.Builder)((CopySource.Builder)CopySource.builder().bucket(bucketName)).object(objectName)).build()).bucket(srcBucketName)).object(srcObjectName)).build());
    }

    public static void removeObject(String bucketName, String objectName) throws Exception {
        minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(bucketName)).object(objectName)).build());
    }

    public static void removeObjects(String bucketName, List<String> objectNames) {
        objectNames.forEach(s -> {
            try {
                MinioUtils.removeObject(bucketName, s);
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u5220\u9664\u5931\u8d25\uff01error:{}", (Object)e.getMessage());
            }
        });
    }

    public static String getPresignedObjectUrl(String bucketName, String objectName, Integer expires) throws Exception {
        String url = minioClient.getPresignedObjectUrl((GetPresignedObjectUrlArgs)((GetPresignedObjectUrlArgs.Builder)((GetPresignedObjectUrlArgs.Builder)GetPresignedObjectUrlArgs.builder().method(Method.GET).bucket(bucketName)).object(objectName)).expiry(expires.intValue()).build());
        return url;
    }

    public static void uploadSnowballObjects(String bucketName, JSONArray fileInfos) throws Exception {
        if (null == fileInfos || fileInfos.size() == 0) {
            return;
        }
        ArrayList<SnowballObject> objects = new ArrayList<SnowballObject>();
        for (int i = 0; i < fileInfos.size(); ++i) {
            JSONObject file = fileInfos.getJSONObject(i);
            objects.add(new SnowballObject(file.getString("name"), (InputStream)new ByteArrayInputStream(file.getString("content").getBytes(StandardCharsets.UTF_8)), (long)file.getString("content").length(), null));
        }
        minioClient.uploadSnowballObjects((UploadSnowballObjectsArgs)((UploadSnowballObjectsArgs.Builder)UploadSnowballObjectsArgs.builder().bucket(bucketName)).objects(objects).build());
    }

    public static String getUtf8ByURLDecoder(String str) throws UnsupportedEncodingException {
        String url = str.replaceAll("%(?![0-9a-fA-F]{2})", "%25");
        return URLDecoder.decode(url, "UTF-8");
    }

    public static void setObjectTags(String bucketname, String objectname, Map<String, String> map) throws Exception {
        minioClient.setObjectTags((SetObjectTagsArgs)((SetObjectTagsArgs.Builder)((SetObjectTagsArgs.Builder)SetObjectTagsArgs.builder().bucket(bucketname)).object(objectname)).tags(map).build());
    }

    public static Tags getObjectTags(String bucketname, String objectname) throws Exception {
        Tags tags = minioClient.getObjectTags((GetObjectTagsArgs)((GetObjectTagsArgs.Builder)((GetObjectTagsArgs.Builder)GetObjectTagsArgs.builder().bucket(bucketname)).object(objectname)).build());
        return tags;
    }

    public static void deleteObjectTags(String bucketname, String objectname) throws Exception {
        minioClient.deleteObjectTags((DeleteObjectTagsArgs)((DeleteObjectTagsArgs.Builder)((DeleteObjectTagsArgs.Builder)DeleteObjectTagsArgs.builder().bucket(bucketname)).object(objectname)).build());
        System.out.println("Object tags deleted successfully");
    }

    public static void getObjectRetention(String bucketname, String objectname) throws Exception {
        Retention retention = minioClient.getObjectRetention((GetObjectRetentionArgs)((GetObjectRetentionArgs.Builder)((GetObjectRetentionArgs.Builder)GetObjectRetentionArgs.builder().bucket(bucketname)).object(objectname)).build());
        System.out.println("Mode: " + retention.mode());
        System.out.println("Retainuntil Date: " + retention.retainUntilDate());
    }

    public static void setObjectRetention(String bucketname, String objectname) throws Exception {
        ZonedDateTime retentionUntil = ZonedDateTime.now(Time.UTC).plusDays(3L).withNano(0);
        Retention config = new Retention(RetentionMode.COMPLIANCE, retentionUntil);
        minioClient.setObjectRetention((SetObjectRetentionArgs)((SetObjectRetentionArgs.Builder)((SetObjectRetentionArgs.Builder)SetObjectRetentionArgs.builder().bucket(bucketname)).object(objectname)).config(config).bypassGovernanceMode(true).build());
    }

    public static void enableObjectLegalHold(String bucketname, String objectname, String versionId) throws Exception {
        minioClient.enableObjectLegalHold((EnableObjectLegalHoldArgs)((EnableObjectLegalHoldArgs.Builder)((EnableObjectLegalHoldArgs.Builder)((EnableObjectLegalHoldArgs.Builder)EnableObjectLegalHoldArgs.builder().bucket(bucketname)).object(objectname)).versionId(versionId)).build());
    }

    public static void disableObjectLegalHold(String bucketname, String objectname) throws Exception {
        minioClient.disableObjectLegalHold((DisableObjectLegalHoldArgs)((DisableObjectLegalHoldArgs.Builder)((DisableObjectLegalHoldArgs.Builder)DisableObjectLegalHoldArgs.builder().bucket(bucketname)).object(objectname)).build());
    }

    public static boolean isObjectLegalHoldEnabled(String bucketname, String objectname) throws Exception {
        return minioClient.isObjectLegalHoldEnabled((IsObjectLegalHoldEnabledArgs)((IsObjectLegalHoldEnabledArgs.Builder)((IsObjectLegalHoldEnabledArgs.Builder)IsObjectLegalHoldEnabledArgs.builder().bucket(bucketname)).object(objectname)).build());
    }

    public static void getObjectLockConfiguration(String bucketname) throws Exception {
        ObjectLockConfiguration config = minioClient.getObjectLockConfiguration((GetObjectLockConfigurationArgs)((GetObjectLockConfigurationArgs.Builder)GetObjectLockConfigurationArgs.builder().bucket("my-lock-enabled-bucketname")).build());
        System.out.println("Object-lock configuration of bucket");
        System.out.println("Mode: " + config.mode());
        System.out.println("Duration: " + config.duration());
    }

    public static void setObjectLockConfiguration(String bucketname) throws Exception {
        ObjectLockConfiguration config = new ObjectLockConfiguration(RetentionMode.COMPLIANCE, (RetentionDuration)new RetentionDurationDays(100));
        minioClient.setObjectLockConfiguration((SetObjectLockConfigurationArgs)((SetObjectLockConfigurationArgs.Builder)SetObjectLockConfigurationArgs.builder().bucket("my-lock-enabled-bucketname")).config(config).build());
        System.out.println("object-lock configuration is set successfully");
    }

    public static ObjectWriteResponse composeObject(JSONArray sourceInfoArr, String destinationBucket, String destinationObject) throws Exception {
        if (null == sourceInfoArr || sourceInfoArr.size() == 0) {
            return null;
        }
        ArrayList<BaseArgs> sources = new ArrayList<BaseArgs>();
        for (int i = 0; i < sourceInfoArr.size(); ++i) {
            JSONObject sourceJson = sourceInfoArr.getJSONObject(i);
            String bucketname = sourceJson.getString("bucketname");
            String objectname = sourceJson.getString("objectname");
            sources.add(((ComposeSource.Builder)((ComposeSource.Builder)ComposeSource.builder().bucket(bucketname)).object(objectname)).build());
        }
        return minioClient.composeObject((ComposeObjectArgs)((ComposeObjectArgs.Builder)((ComposeObjectArgs.Builder)ComposeObjectArgs.builder().bucket(destinationBucket)).object(destinationObject)).sources(sources).build());
    }

    public static void restoreObject(String bucketname, String objectname, String versionid) throws Exception {
        minioClient.restoreObject((RestoreObjectArgs)((RestoreObjectArgs.Builder)((RestoreObjectArgs.Builder)((RestoreObjectArgs.Builder)RestoreObjectArgs.builder().bucket(bucketname)).object(objectname)).versionId(versionid)).request(new RestoreRequest(null, null, null, null, null, null)).build());
    }

    public static Tags getBucketTags(String bucketname) throws Exception {
        return minioClient.getBucketTags((GetBucketTagsArgs)((GetBucketTagsArgs.Builder)GetBucketTagsArgs.builder().bucket(bucketname)).build());
    }

    public static void setBucketTags(String bucketname, Map<String, String> map) throws Exception {
        minioClient.setBucketTags((SetBucketTagsArgs)((SetBucketTagsArgs.Builder)SetBucketTagsArgs.builder().bucket(bucketname)).tags(map).build());
    }

    public static void deleteBucketTags(String bucketname) throws Exception {
        minioClient.deleteBucketTags((DeleteBucketTagsArgs)((DeleteBucketTagsArgs.Builder)DeleteBucketTagsArgs.builder().bucket(bucketname)).build());
    }

    public static ReplicationConfiguration getBucketReplication(String bucketname) throws Exception {
        return minioClient.getBucketReplication((GetBucketReplicationArgs)((GetBucketReplicationArgs.Builder)GetBucketReplicationArgs.builder().bucket(bucketname)).build());
    }

    public static void setBucketReplication(String bucketname, Map<String, String> tags) throws Exception {
        ReplicationRule rule = new ReplicationRule(new DeleteMarkerReplication(Status.DISABLED), new ReplicationDestination(null, null, "REPLACE-WITH-ACTUAL-DESTINATION-BUCKET-ARN", null, null, null, null), null, new RuleFilter(new AndOperator("TaxDocs", tags)), "rule1", null, Integer.valueOf(1), null, Status.ENABLED);
        LinkedList<ReplicationRule> rules = new LinkedList<ReplicationRule>();
        rules.add(rule);
        ReplicationConfiguration config = new ReplicationConfiguration("REPLACE-WITH-ACTUAL-ROLE", rules);
        minioClient.setBucketReplication((SetBucketReplicationArgs)((SetBucketReplicationArgs.Builder)SetBucketReplicationArgs.builder().bucket(bucketname)).config(config).build());
    }

    public static void deleteBucketReplication(String bucketname, String objectname) throws Exception {
        minioClient.deleteBucketReplication((DeleteBucketReplicationArgs)((DeleteBucketReplicationArgs.Builder)DeleteBucketReplicationArgs.builder().bucket(bucketname)).build());
    }

    public static void getBucketEncryption(String bucketname) throws Exception {
        SseConfiguration config = minioClient.getBucketEncryption((GetBucketEncryptionArgs)((GetBucketEncryptionArgs.Builder)GetBucketEncryptionArgs.builder().bucket(bucketname)).build());
        if (config.rule() != null) {
            System.out.println("Rule SSE algorithm: " + config.rule().sseAlgorithm());
            if (config.rule().sseAlgorithm() == SseAlgorithm.AWS_KMS) {
                System.out.println("Rule KMS master key ID: " + config.rule().kmsMasterKeyId());
            }
        } else {
            System.out.println("No rule is set in SSE configuration.");
        }
    }

    public static void setBucketEncryption(String bucketname) throws Exception {
        minioClient.setBucketEncryption((SetBucketEncryptionArgs)((SetBucketEncryptionArgs.Builder)SetBucketEncryptionArgs.builder().bucket(bucketname)).config(SseConfiguration.newConfigWithSseS3Rule()).build());
    }

    public static void deleteBucketEncryption(String bucketname, String objectname) throws Exception {
        minioClient.deleteBucketEncryption((DeleteBucketEncryptionArgs)((DeleteBucketEncryptionArgs.Builder)DeleteBucketEncryptionArgs.builder().bucket(bucketname)).build());
        System.out.println("Encryption configuration of my-bucketname is removed successfully");
    }

    public static LifecycleConfiguration getBucketLifecycle(String bucketname) throws Exception {
        return minioClient.getBucketLifecycle((GetBucketLifecycleArgs)((GetBucketLifecycleArgs.Builder)GetBucketLifecycleArgs.builder().bucket(bucketname)).build());
    }

    public static void setBucketLifecycle(String bucketname) throws Exception {
        LinkedList<LifecycleRule> rules = new LinkedList<LifecycleRule>();
        rules.add(new LifecycleRule(Status.ENABLED, null, new Expiration((ZonedDateTime)null, Integer.valueOf(365), null), new RuleFilter("logs/"), "rule2", null, null, null));
        LifecycleConfiguration config = new LifecycleConfiguration(rules);
        minioClient.setBucketLifecycle((SetBucketLifecycleArgs)((SetBucketLifecycleArgs.Builder)SetBucketLifecycleArgs.builder().bucket(bucketname)).config(config).build());
    }

    public static void deleteBucketLifecycle(String bucketname) throws Exception {
        minioClient.deleteBucketLifecycle((DeleteBucketLifecycleArgs)((DeleteBucketLifecycleArgs.Builder)DeleteBucketLifecycleArgs.builder().bucket(bucketname)).build());
    }

    public static NotificationConfiguration getBucketNotification(String bucketname) throws Exception {
        return minioClient.getBucketNotification((GetBucketNotificationArgs)((GetBucketNotificationArgs.Builder)GetBucketNotificationArgs.builder().bucket(bucketname)).build());
    }

    public static void setBucketNotification(String bucketname) throws Exception {
        NotificationConfiguration config = new NotificationConfiguration();
        LinkedList<QueueConfiguration> queueConfigurationList = new LinkedList<QueueConfiguration>();
        QueueConfiguration queueConfiguration = new QueueConfiguration();
        queueConfiguration.setQueue("arn:minio:sqs::1:webhook");
        LinkedList<EventType> eventList = new LinkedList<EventType>();
        eventList.add(EventType.OBJECT_CREATED_PUT);
        eventList.add(EventType.OBJECT_CREATED_COPY);
        queueConfiguration.setEvents(eventList);
        queueConfiguration.setPrefixRule("images");
        queueConfiguration.setSuffixRule("pg");
        queueConfigurationList.add(queueConfiguration);
        config.setQueueConfigurationList(queueConfigurationList);
        minioClient.setBucketNotification((SetBucketNotificationArgs)((SetBucketNotificationArgs.Builder)SetBucketNotificationArgs.builder().bucket(bucketname)).config(config).build());
        System.out.println("Bucket notification is set successfully");
    }

    public static void deleteBucketNotification(String bucketname) throws Exception {
        minioClient.deleteBucketNotification((DeleteBucketNotificationArgs)((DeleteBucketNotificationArgs.Builder)DeleteBucketNotificationArgs.builder().bucket(bucketname)).build());
        System.out.println("Removed all bucket notification");
    }

    public static void listenBucketNotification(String bucketname) throws Exception {
        String[] events = new String[]{"s3:ObjectCreated:*", "s3:ObjectAccessed:*"};
        CloseableIterator ci = minioClient.listenBucketNotification((ListenBucketNotificationArgs)((ListenBucketNotificationArgs.Builder)ListenBucketNotificationArgs.builder().bucket(bucketname)).prefix("").suffix("").events(events).build());
        try {
            while (ci.hasNext()) {
                NotificationRecords records = (NotificationRecords)((Result)ci.next()).get();
                Event event = (Event)records.events().get(0);
                System.out.println(event.bucketName() + SEPARATOR + event.objectName() + " has been created");
            }
        }
        catch (IOException e) {
            System.out.println("Error occurred: " + e);
        }
    }

    public static VersioningConfiguration getBucketVersioning(String bucketname) throws Exception {
        return minioClient.getBucketVersioning((GetBucketVersioningArgs)((GetBucketVersioningArgs.Builder)GetBucketVersioningArgs.builder().bucket(bucketname)).build());
    }

    public static void setBucketVersioning(String bucketname) throws Exception {
        minioClient.setBucketVersioning((SetBucketVersioningArgs)((SetBucketVersioningArgs.Builder)SetBucketVersioningArgs.builder().bucket(bucketname)).config(new VersioningConfiguration(VersioningConfiguration.Status.SUSPENDED, null)).build());
        System.out.println("Bucket versioning is suspended successfully");
    }

    public static void makeBucket(String bucketname) throws Exception {
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket(bucketname)).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket(bucketname)).build());
            System.out.println("my-bucketname is created successfully");
        }
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket("my-bucketname-in-eu")).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket("my-bucketname-in-eu")).region("eu-west-1")).build());
            System.out.println("my-bucketname-in-eu is created successfully");
        }
        if (!minioClient.bucketExists((BucketExistsArgs)((BucketExistsArgs.Builder)BucketExistsArgs.builder().bucket("my-bucketname-in-eu-with-object-lock")).build())) {
            minioClient.makeBucket((MakeBucketArgs)((MakeBucketArgs.Builder)((MakeBucketArgs.Builder)MakeBucketArgs.builder().bucket("my-bucketname-in-eu-with-object-lock")).region("eu-west-1")).objectLock(true).build());
            System.out.println("my-bucketname-in-eu-with-object-lock is created successfully");
        }
    }

    static {
        enable = false;
        endpoint = "";
        bucketName = "";
        accessKey = "";
        secretKey = "";
        MinioUtils.createMinioClient();
    }
}

