/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.utils;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;

public class MultiFormatWatermarkUtil {
    private static final String[] SUPPORTED_FORMATS = new String[]{"jpg", "jpeg", "gif", "png", "bmp"};

    public static boolean isSupportedFormat(String filePath) {
        String extension = MultiFormatWatermarkUtil.getFileExtension(filePath).toLowerCase();
        for (String format : SUPPORTED_FORMATS) {
            if (!format.equals(extension)) continue;
            return true;
        }
        return false;
    }

    public static String getImageFormat(File file) throws IOException {
        try (ImageInputStream iis = ImageIO.createImageInputStream(file);){
            Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
            if (readers.hasNext()) {
                String string = readers.next().getFormatName().toLowerCase();
                return string;
            }
        }
        throw new IOException("\u65e0\u6cd5\u8bc6\u522b\u7684\u56fe\u7247\u683c\u5f0f");
    }

    public static void addTextWatermark(String sourceImagePath, String targetImagePath, String watermarkText, Font font, Color color, WatermarkPosition position) throws IOException {
        File sourceFile = new File(sourceImagePath);
        if (!sourceFile.exists()) {
            throw new IOException("\u6e90\u6587\u4ef6\u4e0d\u5b58\u5728: " + sourceImagePath);
        }
        if (!MultiFormatWatermarkUtil.isSupportedFormat(sourceImagePath)) {
            throw new IOException("\u4e0d\u652f\u6301\u7684\u56fe\u7247\u683c\u5f0f: " + sourceImagePath);
        }
        BufferedImage sourceImage = ImageIO.read(sourceFile);
        BufferedImage targetImage = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), 1);
        Graphics2D g2d = targetImage.createGraphics();
        g2d.setColor(Color.WHITE);
        g2d.fillRect(0, 0, sourceImage.getWidth(), sourceImage.getHeight());
        g2d.drawImage((Image)sourceImage, 0, 0, null);
        g2d.setColor(color);
        g2d.setFont(font);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setComposite(AlphaComposite.getInstance(3, 0.5f));
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int textWidth = fontMetrics.stringWidth(watermarkText);
        int textHeight = fontMetrics.getHeight();
        Point positionPoint = MultiFormatWatermarkUtil.calculatePosition(position, sourceImage.getWidth(), sourceImage.getHeight(), textWidth, textHeight);
        g2d.drawString(watermarkText, positionPoint.x, positionPoint.y);
        g2d.dispose();
        String format = MultiFormatWatermarkUtil.getFileExtension(targetImagePath);
        File targetFile = new File(targetImagePath);
        targetFile.getParentFile().mkdirs();
        if (!ImageIO.write((RenderedImage)targetImage, format, targetFile)) {
            throw new IOException("\u65e0\u6cd5\u5199\u5165\u56fe\u7247\u5230: " + targetImagePath);
        }
    }

    private static Point calculatePosition(WatermarkPosition position, int imageWidth, int imageHeight, int textWidth, int textHeight) {
        int margin = 20;
        switch (position) {
            case TOP_LEFT: {
                return new Point(margin, margin + textHeight);
            }
            case TOP_RIGHT: {
                return new Point(imageWidth - textWidth - margin, margin + textHeight);
            }
            case BOTTOM_LEFT: {
                return new Point(margin, imageHeight - margin);
            }
            case BOTTOM_RIGHT: {
                return new Point(imageWidth - textWidth - margin, imageHeight - margin);
            }
            case CENTER: {
                return new Point((imageWidth - textWidth) / 2, (imageHeight + textHeight) / 2);
            }
        }
        return new Point(imageWidth - textWidth - margin, imageHeight - margin);
    }

    private static String getFileExtension(String filePath) {
        int lastDotIndex = filePath.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < filePath.length() - 1) {
            return filePath.substring(lastDotIndex + 1).toLowerCase();
        }
        return "jpg";
    }

    public static enum WatermarkPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER;

    }
}

