/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.crypto.impl;

import com.jumipm.common.crypto.JumiCrypto;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sm2Crypto
implements JumiCrypto {
    private static final Logger log = LoggerFactory.getLogger(Sm2Crypto.class);
    private static final String ALGORITHM = "EC";
    private static final String TRANSFORMATION = "SM2";

    @Override
    public String encrypt(String plainText, String publicKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] cipherText = new byte[]{};
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
            byte[] encodedKey = Base64.decode((byte[])publicKey.getBytes(StandardCharsets.UTF_8));
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(encodedKey);
            byte[] data = plainText.getBytes(StandardCharsets.UTF_8);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(1, keyFactory.generatePublic(publicKeySpec));
            cipherText = cipher.doFinal(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(Base64.encode((byte[])cipherText), StandardCharsets.UTF_8);
    }

    @Override
    public String decrypt(String encryptedText, String privateKey) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        byte[] plainText = new byte[]{};
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(ALGORITHM, "BC");
            byte[] encodedKey = Base64.decode((byte[])privateKey.getBytes(StandardCharsets.UTF_8));
            PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(encodedKey);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION, "BC");
            cipher.init(2, keyFactory.generatePrivate(privateKeySpec));
            plainText = cipher.doFinal(Base64.decode((byte[])encryptedText.getBytes(StandardCharsets.UTF_8)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new String(plainText, StandardCharsets.UTF_8);
    }
}

