/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.common.http;

import com.alibaba.fastjson.JSONObject;
import com.jumipm.utils.ApiReturnV3;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;

public class ApiRequest {
    @Value(value="${xpm.v3.server.url}")
    private String baseUrl;
    private String apiUrl;
    private CloseableHttpClient httpClient;

    public void init() {
        this.apiUrl = this.baseUrl + "/apiV3";
        this.httpClient = HttpClients.createDefault();
    }

    public ApiReturnV3 getToken(String userCode, String password) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + "/login/getToken");
            ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
            params.add(new BasicNameValuePair("userCode", userCode));
            params.add(new BasicNameValuePair("password", password));
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return (ApiReturnV3)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ApiReturnV3.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiReturnV3 apiPostRequest(String token, String url, List<NameValuePair> params) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + url);
            httpPost.setHeader("Authorization", token);
            httpPost.addHeader("Content-Type", "application/x-www-form-urlencoded");
            if (!CollectionUtils.isEmpty(params)) {
                httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(params, "UTF-8"));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return (ApiReturnV3)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ApiReturnV3.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiReturnV3 apiPostRequest(String token, String url, String body) {
        try {
            HttpPost httpPost = new HttpPost(this.apiUrl + url);
            httpPost.setHeader("Authorization", token);
            httpPost.addHeader("Content-Type", "application/json");
            if (StringUtils.isNotEmpty((CharSequence)body)) {
                httpPost.setEntity((HttpEntity)new StringEntity(body, "utf-8"));
            }
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpPost);
            return (ApiReturnV3)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ApiReturnV3.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ApiReturnV3 apiGetRequest(String token, String url) {
        try {
            HttpGet httpGet = new HttpGet(this.apiUrl + url);
            httpGet.setHeader("Authorization", token);
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)httpGet);
            return (ApiReturnV3)JSONObject.parseObject((String)EntityUtils.toString((HttpEntity)response.getEntity()), ApiReturnV3.class);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

