/*
 * Decompiled with CFR 0.152.
 */
package com.jumipm.api3.login.service.impl;

import com.jumipm.api3.human.model.XpmV3Human;
import com.jumipm.api3.human.service.XpmV3HumanService;
import com.jumipm.api3.human.service.XpmV3UserService;
import com.jumipm.api3.login.service.LoginV3Service;
import com.jumipm.common.exception.BusinessException;
import com.jumipm.common.redis.BaseRedisTemplate;
import com.jumipm.utils.ApiConstant;
import com.jumipm.utils.CacheParm;
import com.jumipm.utils.CodeGenerator;
import com.jumipm.utils.SysApiV3Info;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class LoginV3ServiceImpl
implements LoginV3Service {
    private static final Logger log = LoggerFactory.getLogger(LoginV3ServiceImpl.class);
    @Resource
    private BaseRedisTemplate<CacheParm<SysApiV3Info>> baseRedisTemplate;
    @Resource
    private XpmV3HumanService xpmV3HumanService;
    @Resource
    private XpmV3UserService xpmV3UserService;

    @Override
    public SysApiV3Info getToken(String userCode, String password) {
        log.info("getToken userCode is {}", (Object)userCode);
        XpmV3Human human = this.xpmV3HumanService.getEnableHumanByCode(userCode);
        if (human == null) {
            throw new BusinessException("403", "\u8be5\u8d26\u53f7\u4e0d\u5b58\u5728\u6216\u5df2\u505c\u7528\uff01");
        }
        boolean b = this.xpmV3UserService.checkPassword(human.getHumanSid(), password);
        if (!b) {
            throw new BusinessException("403", "\u5bc6\u7801\u4e0d\u6b63\u786e\uff01");
        }
        String token = CodeGenerator.getUUID();
        SysApiV3Info info = new SysApiV3Info();
        info.setToken(token);
        info.setUserCode(userCode);
        info.setHumanSid(human.getHumanSid());
        info.setHumanName(human.getHumanName());
        CacheParm cache = new CacheParm((Object)info);
        this.baseRedisTemplate.set("API_V3:" + token, (Object)cache, ApiConstant.API_V3_AUTHOR_TIMEOUT);
        return info;
    }
}

