/*
 * Decompiled with CFR 0.152.
 */
package io.rong;

import io.rong.methods.chatroom.Chatroom;
import io.rong.methods.conversation.Conversation;
import io.rong.methods.group.Group;
import io.rong.methods.message.Message;
import io.rong.methods.push.Push;
import io.rong.methods.sensitive.SensitiveWord;
import io.rong.methods.sensitive.Wordfilter;
import io.rong.methods.user.User;
import io.rong.util.HostType;
import io.rong.util.HttpUtil;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class RongCloud {
    private static ConcurrentHashMap<String, RongCloud> rongCloud = new ConcurrentHashMap();
    public User user;
    public Message message;
    public Wordfilter wordfilter;
    public SensitiveWord sensitiveword;
    public Group group;
    public Chatroom chatroom;
    public Conversation conversation;
    public Push push;
    private HostType apiHostType = new HostType("http://api-cn.ronghub.com");
    private HostType smsHostType = new HostType("http://api.sms.ronghub.com");
    private static List<HostType> apiHostListBackUp = new CopyOnWriteArrayList<HostType>();

    public HostType getApiHostType() {
        if (HttpUtil.timeoutNum.get() >= 1) {
            for (HostType host : apiHostListBackUp) {
                if (this.apiHostType.getStrType().equals(host.getStrType())) continue;
                HttpUtil.timeoutNum.set(0);
                this.setApiHostType(host);
                return host;
            }
        }
        return this.apiHostType;
    }

    public void setApiHostType(HostType apiHostType) {
        this.apiHostType = apiHostType;
    }

    public HostType getSmsHostType() {
        return this.smsHostType;
    }

    public void setSmsHostType(HostType smsHostType) {
        this.smsHostType = smsHostType;
    }

    public static List<HostType> getApiHostListBackUp() {
        return apiHostListBackUp;
    }

    public static void setApiHostListBackUp(List<HostType> apiHostListBackUp) {
        RongCloud.apiHostListBackUp = apiHostListBackUp;
    }

    private RongCloud(String appKey, String appSecret) {
        this.user = new User(appKey, appSecret, this);
        this.message = new Message(appKey, appSecret);
        this.message.setRongCloud(this);
        this.wordfilter = new Wordfilter(appKey, appSecret);
        this.wordfilter.setRongCloud(this);
        this.sensitiveword = new SensitiveWord(appKey, appSecret);
        this.sensitiveword.setRongCloud(this);
        this.group = new Group(appKey, appSecret, this);
        this.chatroom = new Chatroom(appKey, appSecret, this);
        this.chatroom.setRongCloud(this);
        this.conversation = new Conversation(appKey, appSecret);
        this.conversation.setRongCloud(this);
        this.push = new Push(appKey, appSecret);
        this.push.setRongCloud(this);
    }

    public static RongCloud getInstance(String appKey, String appSecret) {
        RongCloud rong;
        if (null == rongCloud.get(appKey) && (rong = rongCloud.putIfAbsent(appKey, new RongCloud(appKey, appSecret))) == null) {
            apiHostListBackUp.add(new HostType("http://api-cn.ronghub.com"));
            apiHostListBackUp.add(new HostType("http://api2-cn.ronghub.com"));
        }
        return rongCloud.get(appKey);
    }

    public static RongCloud getInstance(String appKey, String appSecret, String api) {
        if (null == rongCloud.get(appKey)) {
            RongCloud rc = new RongCloud(appKey, appSecret);
            if (api != null && api.trim().length() > 0) {
                rc.setApiHostType(new HostType(api));
            }
            rongCloud.putIfAbsent(appKey, rc);
        }
        return rongCloud.get(appKey);
    }

    public static RongCloud getInstance(String appKey, String appSecret, String api, List<String> apiBackUp) {
        if (null == rongCloud.get(appKey)) {
            RongCloud rc = new RongCloud(appKey, appSecret);
            if (api != null && api.trim().length() > 0) {
                rc.setApiHostType(new HostType(api));
                apiHostListBackUp.add(new HostType(api));
            }
            for (String apiHost : apiBackUp) {
                apiHostListBackUp.add(new HostType(apiHost));
            }
            rongCloud.putIfAbsent(appKey, rc);
        }
        return rongCloud.get(appKey);
    }
}

