/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.push;

import io.rong.RongCloud;
import io.rong.models.push.BroadcastModel;
import io.rong.models.push.PushModel;
import io.rong.models.response.PushResult;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;

public class Push {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "push";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Push(String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
    }

    public PushResult message(BroadcastModel broadcast) throws Exception {
        String message = CommonUtil.checkFiled(broadcast, PATH, "broadcast");
        if (null != message) {
            return (PushResult)GsonUtil.fromJson(message, PushResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/push.json", "application/json");
        HttpUtil.setBodyParameter(broadcast.toString(), conn);
        return (PushResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "broadcast", HttpUtil.returnResult(conn)), PushResult.class);
    }

    public PushResult push(PushModel push) throws Exception {
        String message = CommonUtil.checkFiled(push, PATH, PATH);
        if (null != message) {
            return (PushResult)GsonUtil.fromJson(message, PushResult.class);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/push.json", "application/json");
        HttpUtil.setBodyParameter(push.toString(), conn);
        return (PushResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, PATH, HttpUtil.returnResult(conn)), PushResult.class);
    }
}

