/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.onlinestatus;

import io.rong.RongCloud;
import io.rong.models.response.CheckOnlineResult;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class OnlineStatus {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/online-status";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public OnlineStatus(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public CheckOnlineResult check(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "check");
        if (null != message) {
            return (CheckOnlineResult)GsonUtil.fromJson(message, CheckOnlineResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.id.toString(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1, body.length());
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/checkOnline.json", "application/x-www-form-urlencoded");
        HttpUtil.setBodyParameter(body, conn);
        return (CheckOnlineResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "check", HttpUtil.returnResult(conn)), CheckOnlineResult.class);
    }
}

