/*
 * Decompiled with CFR 0.152.
 */
package io.rong.methods.user.whitelist;

import io.rong.RongCloud;
import io.rong.models.Result;
import io.rong.models.response.PWhiteListResult;
import io.rong.models.response.ResponseResult;
import io.rong.models.user.UserModel;
import io.rong.util.CommonUtil;
import io.rong.util.GsonUtil;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URLEncoder;

public class Whitelist {
    private static final String UTF8 = "UTF-8";
    private static final String PATH = "user/whitelist";
    private static final String CONTENTTYPE = "application/x-www-form-urlencoded";
    private String appKey;
    private String appSecret;
    private RongCloud rongCloud;

    public RongCloud getRongCloud() {
        return this.rongCloud;
    }

    public void setRongCloud(RongCloud rongCloud) {
        this.rongCloud = rongCloud;
    }

    public Whitelist(String appKey, String appSecret, RongCloud rongCloud) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.rongCloud = rongCloud;
    }

    public Result add(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "add");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        String body = this.createBodyContent(user);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/whitelist/add.json");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "add", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    public PWhiteListResult getList(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "getList");
        if (null != message) {
            return (PWhiteListResult)GsonUtil.fromJson(message, PWhiteListResult.class);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId(), UTF8));
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1);
        }
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/whitelist/query.json");
        HttpUtil.setBodyParameter(body, conn);
        return (PWhiteListResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "getList", HttpUtil.returnResult(conn)), PWhiteListResult.class);
    }

    public Result remove(UserModel user) throws Exception {
        String message = CommonUtil.checkFiled(user, PATH, "remove");
        if (null != message) {
            return (ResponseResult)GsonUtil.fromJson(message, ResponseResult.class);
        }
        String body = this.createBodyContent(user);
        HttpURLConnection conn = HttpUtil.CreatePostHttpConnection(this.rongCloud.getApiHostType(), this.appKey, this.appSecret, "/user/whitelist/remove.json");
        HttpUtil.setBodyParameter(body, conn);
        return (ResponseResult)GsonUtil.fromJson(CommonUtil.getResponseByCode(PATH, "remove", HttpUtil.returnResult(conn)), ResponseResult.class);
    }

    private String createBodyContent(UserModel user) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append("&userId=").append(URLEncoder.encode(user.getId(), UTF8));
        for (UserModel whiteUser : user.getWhitelist()) {
            sb.append("&whiteUserId=").append(URLEncoder.encode(whiteUser.getId(), UTF8));
        }
        String body = sb.toString();
        if (body.indexOf("&") == 0) {
            body = body.substring(1);
        }
        return body;
    }
}

