/*
 * Decompiled with CFR 0.152.
 */
package io.rong.util;

import com.alibaba.fastjson.JSONObject;
import io.rong.util.GsonUtil;
import io.rong.util.HostType;
import io.rong.util.HttpUtil;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import org.apache.commons.codec.digest.DigestUtils;

public class BaiduHttpDNSUtil {
    public static String uri = "http://180.76.76.200/v3/resolve";
    private static final String UTF8 = "UTF-8";

    public static String getFirstIp(String account_id, String secret, String dn) throws Exception {
        if (account_id == null || secret == null || dn == null || account_id.equals("") || secret.equals("") || dn.equals("")) {
            throw new Exception("account_id\u3001secret and dn is required.");
        }
        String timestamp = String.valueOf(System.currentTimeMillis() / 1000L + 10L);
        String sign = DigestUtils.md5Hex((String)(dn + "-" + secret + "-" + timestamp));
        StringBuilder sb = new StringBuilder();
        sb.append("?account_id=").append(URLEncoder.encode(account_id, UTF8));
        sb.append("&dn=").append(URLEncoder.encode(dn, UTF8));
        sb.append("&t=").append(URLEncoder.encode(timestamp, UTF8));
        sb.append("&sign=").append(URLEncoder.encode(sign, UTF8));
        String param = sb.toString();
        URL url = new URL(uri + param);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        conn.setConnectTimeout(30000);
        String result = HttpUtil.returnResult(conn);
        JSONObject btResult = (JSONObject)GsonUtil.fromJson(result, JSONObject.class);
        JSONObject data = btResult.getJSONObject("data");
        if (data == null || !data.containsKey((Object)dn)) {
            throw new Exception("BaiduHttpDNSUtil: " + result);
        }
        return data.getJSONObject(dn).getJSONArray("ip").getString(0);
    }

    public static void setHostTypeIp(String account_id, String secret, HostType hostType) throws Exception {
        hostType.setIp(BaiduHttpDNSUtil.getFirstIp(account_id, secret, new URL(hostType.getStrType()).getHost()));
    }
}

