/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplInstant;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalDateTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocalTime;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplZonedDateTime;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;

public abstract class FieldReader<T>
implements Comparable<FieldReader> {
    public final int ordinal;
    public final String fieldName;
    public final Class fieldClass;
    public final Type fieldType;
    public final long features;
    public final String format;
    public final Method method;
    public final Field field;
    public final Object defaultValue;
    public final Locale locale;
    public final JSONSchema schema;
    final boolean fieldClassSerializable;
    final long fieldNameHash;
    final long fieldNameHashLCase;
    volatile ObjectReader reader;
    volatile JSONPath referenceCache;
    final boolean noneStaticMemberClass;
    Type itemType;
    Class itemClass;
    volatile ObjectReader itemReader;

    public FieldReader(String fieldName, Type fieldType) {
        this(fieldName, fieldType, TypeUtils.getClass(fieldType), 0, 0L, null, null, null, null, null, null);
    }

    public FieldReader(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Object defaultValue) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && (Serializable.class.isAssignableFrom(fieldClass) || !Modifier.isInterface(fieldClass.getModifiers()));
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.fieldNameHashLCase = Fnv.hashCode64LCase(fieldName);
        this.ordinal = ordinal;
        this.format = format;
        this.locale = null;
        this.defaultValue = defaultValue;
        this.schema = null;
        this.method = null;
        this.field = null;
        this.noneStaticMemberClass = BeanUtils.isNoneStaticMemberClass(null, fieldClass);
    }

    public FieldReader(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema, Method method, Field field) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && (Serializable.class.isAssignableFrom(fieldClass) || Modifier.isInterface(fieldClass.getModifiers()));
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.fieldNameHashLCase = Fnv.hashCode64LCase(fieldName);
        this.ordinal = ordinal;
        this.format = format;
        this.locale = locale;
        this.defaultValue = defaultValue;
        this.schema = schema;
        this.method = method;
        this.field = field;
        Class<?> declaringClass = null;
        if (method != null) {
            declaringClass = method.getDeclaringClass();
        } else if (field != null) {
            declaringClass = field.getDeclaringClass();
        }
        this.noneStaticMemberClass = BeanUtils.isNoneStaticMemberClass(declaringClass, fieldClass);
    }

    public void acceptDefaultValue(T object) {
        if (this.defaultValue != null) {
            this.accept(object, this.defaultValue);
        }
    }

    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.format != null && !this.format.isEmpty()) {
            String typeName;
            switch (typeName = this.fieldType.getTypeName()) {
                case "java.sql.Time": {
                    this.reader = JdbcSupport.createTimeReader((Class)this.fieldType, this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Timestamp": {
                    this.reader = JdbcSupport.createTimestampReader((Class)this.fieldType, this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader((Class)this.fieldType, this.format, this.locale);
                }
            }
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    public ObjectReader getObjectReader(JSONReader.Context context) {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.format != null && !this.format.isEmpty()) {
            String typeName;
            switch (typeName = this.fieldType.getTypeName()) {
                case "java.sql.Time": {
                    this.reader = JdbcSupport.createTimeReader((Class)this.fieldType, this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Timestamp": {
                    this.reader = JdbcSupport.createTimestampReader((Class)this.fieldType, this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader((Class)this.fieldType, this.format, this.locale);
                }
            }
        }
        this.reader = context.getObjectReader(this.fieldType);
        return this.reader;
    }

    public Type getItemType() {
        return this.itemType;
    }

    public Class getItemClass() {
        if (this.itemType == null) {
            return null;
        }
        if (this.itemClass == null) {
            this.itemClass = TypeUtils.getClass(this.itemType);
        }
        return this.itemClass;
    }

    public long getItemClassHash() {
        Class itemClass = this.getItemClass();
        if (itemClass == null) {
            return 0L;
        }
        return Fnv.hashCode64(itemClass.getName());
    }

    public String toString() {
        AccessibleObject member;
        AccessibleObject accessibleObject = member = this.method != null ? this.method : this.field;
        if (member != null) {
            return member.getName();
        }
        return this.fieldName;
    }

    public void addResolveTask(JSONReader jsonReader, Object object, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(this, object, path);
    }

    public void addResolveTask(JSONReader jsonReader, Collection object, int i, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(object, i, path);
    }

    @Override
    public int compareTo(FieldReader o) {
        Class<?> superClass;
        Class<?> otherFieldDeclaringClass;
        Class<?> thisFieldDeclaringClass;
        AccessibleObject otherMember;
        int cmp;
        int nameCompare = this.fieldName.compareTo(o.fieldName);
        if (nameCompare != 0) {
            if (this.ordinal < o.ordinal) {
                return -1;
            }
            if (this.ordinal > o.ordinal) {
                return 1;
            }
            return nameCompare;
        }
        int n = this.isReadOnly() == o.isReadOnly() ? 0 : (cmp = this.isReadOnly() ? 1 : -1);
        if (cmp != 0) {
            return cmp;
        }
        AccessibleObject thisMember = this.field != null ? this.field : this.method;
        AccessibleObject accessibleObject = otherMember = o.field != null ? o.field : o.method;
        if (thisMember != null && otherMember != null && thisMember.getClass() != otherMember.getClass()) {
            Class<?> otherDeclaringClass = otherMember.getDeclaringClass();
            Class<?> thisDeclaringClass = thisMember.getDeclaringClass();
            if (thisDeclaringClass != otherDeclaringClass && thisDeclaringClass != null && otherDeclaringClass != null) {
                if (thisDeclaringClass.isAssignableFrom(otherDeclaringClass)) {
                    return 1;
                }
                if (otherDeclaringClass.isAssignableFrom(thisDeclaringClass)) {
                    return -1;
                }
            }
        }
        if (this.field != null && o.field != null) {
            thisFieldDeclaringClass = this.field.getDeclaringClass();
            otherFieldDeclaringClass = o.field.getDeclaringClass();
            for (superClass = thisFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != otherFieldDeclaringClass) continue;
                return 1;
            }
            for (superClass = otherFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != thisFieldDeclaringClass) continue;
                return -1;
            }
        }
        if (this.method != null && o.method != null) {
            thisFieldDeclaringClass = this.method.getDeclaringClass();
            otherFieldDeclaringClass = o.method.getDeclaringClass();
            for (superClass = thisFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != otherFieldDeclaringClass) continue;
                return 1;
            }
            for (superClass = otherFieldDeclaringClass.getSuperclass(); superClass != null && superClass != Object.class; superClass = superClass.getSuperclass()) {
                if (superClass != thisFieldDeclaringClass) continue;
                return -1;
            }
            if (this.method.getParameterCount() == 1 && o.method.getParameterCount() == 1) {
                Class<?> otherParamType;
                Class<?> thisParamType = this.method.getParameterTypes()[0];
                if (thisParamType.isAssignableFrom(otherParamType = o.method.getParameterTypes()[0])) {
                    return 1;
                }
                if (otherParamType.isAssignableFrom(thisParamType)) {
                    return -1;
                }
                if (thisParamType.isEnum() && (otherParamType == Integer.class || otherParamType == Integer.TYPE)) {
                    return 1;
                }
                if (otherParamType.isEnum() && (thisParamType == Integer.class || thisParamType == Integer.TYPE)) {
                    return -1;
                }
            }
        }
        ObjectReader thisInitReader = this.getInitReader();
        ObjectReader otherInitReader = o.getInitReader();
        if (thisInitReader != null && otherInitReader == null) {
            return -1;
        }
        if (thisInitReader == null && otherInitReader != null) {
            return 1;
        }
        return cmp;
    }

    public boolean isUnwrapped() {
        return (this.features & 0x2000000000000L) != 0L;
    }

    public void addResolveTask(JSONReader jsonReader, List object, int i, String reference) {
        jsonReader.addResolveTask(object, i, JSONPath.of(reference));
    }

    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        this.readFieldValue(jsonReader, object);
    }

    public Object readFieldValue(JSONReader jsonReader) {
        return null;
    }

    public void accept(T object, boolean value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, byte value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, short value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, int value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, long value) {
        this.accept(object, (Object)value);
    }

    public void accept(T object, char value) {
        this.accept(object, Character.valueOf(value));
    }

    public void accept(T object, float value) {
        this.accept(object, Float.valueOf(value));
    }

    public void accept(T object, double value) {
        this.accept(object, (Object)value);
    }

    public abstract void accept(T var1, Object var2);

    public abstract void readFieldValue(JSONReader var1, T var2);

    public ObjectReader checkObjectAutoType(JSONReader jsonReader) {
        if (jsonReader.nextIfMatch((byte)-110)) {
            long typeHash = jsonReader.readTypeHashCode();
            boolean isSupportAutoType = jsonReader.isSupportAutoType(this.features);
            if (!isSupportAutoType) {
                throw new JSONException(jsonReader.info("autoType not support input " + jsonReader.getString()));
            }
            ObjectReader autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeHash);
            if (autoTypeObjectReader == null) {
                String typeName = jsonReader.getString();
                autoTypeObjectReader = jsonReader.getContext().getObjectReaderAutoType(typeName, this.fieldClass, this.features);
            }
            if (autoTypeObjectReader == null) {
                throw new JSONException("auotype not support : " + jsonReader.getString());
            }
            return autoTypeObjectReader;
        }
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public ObjectReader getInitReader() {
        return null;
    }

    public void processExtra(JSONReader jsonReader, Object object) {
        jsonReader.skipValue();
    }

    public ObjectReader getItemObjectReader(JSONReader.Context ctx) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        this.itemReader = ctx.getObjectReader(this.itemType);
        return this.itemReader;
    }

    public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        return this.getItemObjectReader(jsonReader.getContext());
    }

    static ObjectReader createFormattedObjectReader(Type fieldType, Class fieldClass, String format, Locale locale) {
        if (format != null && !format.isEmpty()) {
            String typeName;
            switch (typeName = fieldType.getTypeName()) {
                case "java.sql.Time": {
                    return JdbcSupport.createTimeReader((Class)fieldType, format, locale);
                }
                case "java.sql.Timestamp": {
                    return JdbcSupport.createTimestampReader((Class)fieldType, format, locale);
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader((Class)fieldType, format, locale);
                }
                case "byte[]": 
                case "[B": {
                    return new ObjectReaderImplInt8Array(format);
                }
            }
            if (Calendar.class.isAssignableFrom(fieldClass)) {
                return ObjectReaderImplCalendar.of(format, locale);
            }
            if (fieldClass == ZonedDateTime.class) {
                return ObjectReaderImplZonedDateTime.of(format, locale);
            }
            if (fieldClass == LocalDateTime.class) {
                if (format == null) {
                    return ObjectReaderImplLocalDateTime.INSTANCE;
                }
                return new ObjectReaderImplLocalDateTime(format, locale);
            }
            if (fieldClass == LocalDate.class) {
                if (format == null) {
                    return ObjectReaderImplLocalDate.INSTANCE;
                }
                return new ObjectReaderImplLocalDate(format, locale);
            }
            if (fieldClass == LocalTime.class) {
                if (format == null) {
                    return ObjectReaderImplLocalTime.INSTANCE;
                }
                return new ObjectReaderImplLocalTime(format, locale);
            }
            if (fieldClass == Instant.class) {
                return ObjectReaderImplInstant.of(format, locale);
            }
            if (fieldClass == Optional.class) {
                return ObjectReaderImplOptional.of(fieldType, format, locale);
            }
            if (fieldClass == Date.class) {
                return ObjectReaderImplDate.of(format, locale);
            }
        }
        return null;
    }
}

