/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.util.UnsafeUtils;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;

public class JDKUtils {
    public static final int JVM_VERSION;
    public static final Byte LATIN1;
    public static final Byte UTF16;
    static final Field FIELD_STRING_VALUE;
    static final long FIELD_STRING_VALUE_OFFSET;
    static volatile boolean FIELD_STRING_ERROR;
    static final Class<?> CLASS_SQL_DATASOURCE;
    static final Class<?> CLASS_SQL_ROW_SET;
    public static final boolean HAS_SQL;
    public static final Class CLASS_TRANSIENT;
    public static final boolean BIG_ENDIAN;
    public static final boolean UNSAFE_SUPPORT;
    public static final BiFunction<char[], Boolean, String> STRING_CREATOR_JDK8;
    public static final BiFunction<byte[], Byte, String> STRING_CREATOR_JDK11;
    public static final ToIntFunction<String> STRING_CODER;
    public static final Function<String, byte[]> STRING_VALUE;

    public static boolean isSQLDataSourceOrRowSet(Class<?> type) {
        return CLASS_SQL_DATASOURCE != null && CLASS_SQL_DATASOURCE.isAssignableFrom(type) || CLASS_SQL_ROW_SET != null && CLASS_SQL_ROW_SET.isAssignableFrom(type);
    }

    public static char[] getCharArray(String str) {
        if (!FIELD_STRING_ERROR) {
            try {
                return (char[])UnsafeUtils.UNSAFE.getObject(str, FIELD_STRING_VALUE_OFFSET);
            }
            catch (Exception ignored) {
                FIELD_STRING_ERROR = true;
            }
        }
        return str.toCharArray();
    }

    static MethodHandles.Lookup getLookup() throws Exception {
        MethodHandles.Lookup lookup;
        if (JVM_VERSION >= 15) {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            lookup = (MethodHandles.Lookup)constructor.newInstance(String.class, null, -1);
        } else {
            Constructor constructor = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class, Integer.TYPE);
            constructor.setAccessible(true);
            lookup = (MethodHandles.Lookup)constructor.newInstance(String.class, -1);
        }
        return lookup;
    }

    static {
        boolean unsafeSupport;
        LATIN1 = 0;
        UTF16 = 1;
        boolean openj9 = false;
        int jvmVersion = -1;
        try {
            String property = System.getProperty("java.specification.version");
            if (property.startsWith("1.")) {
                property = property.substring(2);
            }
            jvmVersion = Integer.parseInt(property);
            String jmvName = System.getProperty("java.vm.name");
            openj9 = jmvName.contains("OpenJ9");
            if (openj9) {
                FIELD_STRING_ERROR = true;
            }
        }
        catch (Throwable property) {
            // empty catch block
        }
        boolean hasJavaSql = true;
        Class<?> dataSourceClass = null;
        Class<?> rowSetClass = null;
        try {
            dataSourceClass = Class.forName("javax.sql.DataSource");
            rowSetClass = Class.forName("javax.sql.RowSet");
        }
        catch (Throwable e) {
            hasJavaSql = false;
        }
        CLASS_SQL_DATASOURCE = dataSourceClass;
        CLASS_SQL_ROW_SET = rowSetClass;
        HAS_SQL = hasJavaSql;
        Class<?> transientClass = null;
        try {
            transientClass = Class.forName("java.beans.Transient");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CLASS_TRANSIENT = transientClass;
        JVM_VERSION = jvmVersion;
        if (JVM_VERSION == 8) {
            Field field = null;
            long fieldOffset = -1L;
            try {
                field = String.class.getDeclaredField("value");
                field.setAccessible(true);
                fieldOffset = UnsafeUtils.objectFieldOffset(field);
            }
            catch (Exception ignored) {
                FIELD_STRING_ERROR = true;
            }
            FIELD_STRING_VALUE = field;
            FIELD_STRING_VALUE_OFFSET = fieldOffset;
        } else {
            FIELD_STRING_ERROR = true;
            FIELD_STRING_VALUE = null;
            FIELD_STRING_VALUE_OFFSET = -1L;
        }
        UNSAFE_SUPPORT = unsafeSupport = ((Predicate<Object>)o -> {
            try {
                return UnsafeUtils.UNSAFE != null;
            }
            catch (Throwable ignored) {
                return false;
            }
        }).test(null);
        BIG_ENDIAN = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
        BiFunction stringCreatorJDK8 = null;
        BiFunction stringCreatorJDK11 = null;
        ToIntFunction stringCoder = null;
        Function stringValue = null;
        try {
            boolean lookupLambda;
            if (JVM_VERSION == 8) {
                MethodHandles.Lookup lookup = JDKUtils.getLookup();
                MethodHandles.Lookup caller = lookup.in(String.class);
                MethodHandle handle = caller.findConstructor(String.class, MethodType.methodType(Void.TYPE, char[].class, Boolean.TYPE));
                CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, handle.type());
                stringCreatorJDK8 = callSite.getTarget().invokeExact();
            }
            if (JVM_VERSION > 8 && JVM_VERSION < 16) {
                lookupLambda = true;
            } else {
                List<String> inputArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                boolean bl = lookupLambda = inputArguments.contains("--add-opens=java.base/java.lang.invoke=ALL-UNNAMED") || inputArguments.contains("--add-opens=java.base/java.lang.invoke=com.alibaba.fastjson2");
            }
            if (lookupLambda) {
                MethodHandles.Lookup lookup = JDKUtils.getLookup();
                MethodHandles.Lookup caller = lookup.in(String.class);
                MethodHandle handle = caller.findConstructor(String.class, MethodType.methodType(Void.TYPE, byte[].class, Byte.TYPE));
                CallSite callSite = LambdaMetafactory.metafactory(caller, "apply", MethodType.methodType(BiFunction.class), handle.type().generic(), handle, MethodType.methodType(String.class, byte[].class, Byte.class));
                stringCreatorJDK11 = callSite.getTarget().invokeExact();
                MethodHandles.Lookup stringCaller = lookup.in(String.class);
                MethodHandle coder = stringCaller.findSpecial(String.class, "coder", MethodType.methodType(Byte.TYPE), String.class);
                CallSite applyAsInt = LambdaMetafactory.metafactory(stringCaller, "applyAsInt", MethodType.methodType(ToIntFunction.class), MethodType.methodType(Integer.TYPE, Object.class), coder, coder.type());
                stringCoder = applyAsInt.getTarget().invokeExact();
                MethodHandle value = stringCaller.findSpecial(String.class, "value", MethodType.methodType(byte[].class), String.class);
                CallSite apply = LambdaMetafactory.metafactory(stringCaller, "apply", MethodType.methodType(Function.class), value.type().generic(), value, value.type());
                stringValue = apply.getTarget().invokeExact();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (stringCreatorJDK11 == null && unsafeSupport && !openj9) {
            stringCreatorJDK11 = ((Supplier<BiFunction>)() -> {
                try {
                    return new UnsafeUtils.UnsafeStringCreator();
                }
                catch (Throwable e) {
                    return null;
                }
            }).get();
        }
        STRING_CREATOR_JDK8 = stringCreatorJDK8;
        STRING_CREATOR_JDK11 = stringCreatorJDK11;
        STRING_CODER = stringCoder;
        STRING_VALUE = stringValue;
    }
}

