/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Field;

final class FieldWriterFloatValField<T>
extends FieldWriter<T> {
    FieldWriterFloatValField(String name, int ordinal, String format, String label, Field field) {
        super(name, ordinal, 0L, format, label, Float.TYPE, Float.TYPE, field, null);
    }

    @Override
    public Object getFieldValue(T object) {
        return Float.valueOf(this.getFieldValueFloat(object));
    }

    public float getFieldValueFloat(T object) {
        try {
            return this.field.getFloat(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new JSONException("field.get error, " + this.fieldName, e);
        }
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        float value = this.getFieldValueFloat(object);
        this.writeFloat(jsonWriter, value);
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        float value = this.getFieldValueFloat(object);
        jsonWriter.writeFloat(value);
    }
}

