/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class CheckResult {
    private final Verdict verdict;
    @Nullable
    private final Object actualValue;
    private final LocalDateTime timestamp;
    private static final DateTimeFormatter timeFormat = DateTimeFormatter.ofPattern("HH:mm:ss:SSS");

    public CheckResult(Verdict verdict, @Nullable Object actualValue) {
        this(verdict, actualValue, LocalDateTime.now());
    }

    public CheckResult(boolean checkSucceeded, @Nullable Object actualValue) {
        this(checkSucceeded ? Verdict.ACCEPT : Verdict.REJECT, actualValue);
    }

    public CheckResult(Verdict verdict, @Nullable Object actualValue, LocalDateTime timestamp) {
        this.verdict = verdict;
        this.actualValue = actualValue;
        this.timestamp = timestamp;
    }

    public String toString() {
        return String.format("%s @ %s%n", this.actualValue, timeFormat.format(this.timestamp));
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.verdict != null ? this.verdict.hashCode() : 0);
        result = 31 * result + (this.actualValue != null ? this.actualValue.hashCode() : 0);
        result = 31 * result + (this.timestamp != null ? this.timestamp.hashCode() : 0);
        return result;
    }

    public final boolean equals(Object arg0) {
        if (this == arg0) {
            return true;
        }
        if (arg0 == null) {
            return false;
        }
        if (arg0.getClass() != this.getClass()) {
            return false;
        }
        if (!Objects.equals((Object)((CheckResult)arg0).verdict, (Object)this.verdict)) {
            return false;
        }
        if (!Objects.equals(((CheckResult)arg0).actualValue, this.actualValue)) {
            return false;
        }
        return Objects.equals(((CheckResult)arg0).timestamp, this.timestamp);
        {
        }
    }

    public Verdict verdict() {
        return this.verdict;
    }

    @Nullable
    public Object actualValue() {
        return this.actualValue;
    }

    public LocalDateTime timestamp() {
        return this.timestamp;
    }

    public static enum Verdict {
        ACCEPT,
        REJECT;

    }
}

