/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class DragAndDropOptions {
    private final DragAndDropMethod method;

    public DragAndDropOptions(DragAndDropMethod method) {
        this.method = method;
    }

    @CheckReturnValue
    @Nonnull
    public static DragAndDropOptions usingJavaScript() {
        return new DragAndDropOptions(DragAndDropMethod.JS);
    }

    @CheckReturnValue
    @Nonnull
    public static DragAndDropOptions usingActions() {
        return new DragAndDropOptions(DragAndDropMethod.ACTIONS);
    }

    @CheckReturnValue
    @Nonnull
    public DragAndDropMethod getMethod() {
        return this.method;
    }

    public String toString() {
        return String.format("method: %s", new Object[]{this.method});
    }

    public static enum DragAndDropMethod {
        ACTIONS,
        JS;

    }
}

