/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.SetValueMethod;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SetValueOptions {
    private static final Pattern REGEX_ANY_CHAR = Pattern.compile(".");
    private final CharSequence value;
    private final CharSequence displayedText;
    private final SetValueMethod method;

    protected SetValueOptions(SetValueMethod method, CharSequence value, CharSequence displayedText) {
        this.method = method;
        this.value = value;
        this.displayedText = displayedText;
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withText(CharSequence text) {
        return new SetValueOptions(SetValueMethod.SEND_KEYS, text, text);
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withDate(LocalDate date) {
        return new SetValueOptions(SetValueMethod.JS, date.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")), date.format(DateTimeFormatter.ofPattern("dd.MM.yyyy")));
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions withDisplayedText(CharSequence displayedText) {
        return new SetValueOptions(this.method, this.value, displayedText);
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions usingMethod(SetValueMethod method) {
        return new SetValueOptions(method, this.value, this.displayedText);
    }

    @CheckReturnValue
    public CharSequence value() {
        return this.value;
    }

    @CheckReturnValue
    @Nonnull
    public SetValueMethod method() {
        return this.method;
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions sensitive() {
        return new SetValueOptions(this.method, this.value, this.mask(this.value));
    }

    @Nonnull
    @CheckReturnValue
    private String mask(CharSequence text) {
        return REGEX_ANY_CHAR.matcher(text).replaceAll("*");
    }

    public String toString() {
        if (this.method == SetValueMethod.SEND_KEYS) {
            return this.displayedText.toString();
        }
        return String.format("\"%s\" (feat. %s)", new Object[]{this.displayedText, this.method});
    }
}

