/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.collections.ExactTexts;
import com.codeborne.selenide.impl.Html;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ExactTextsCaseSensitive
extends ExactTexts {
    public ExactTextsCaseSensitive(String ... expectedTexts) {
        super(expectedTexts);
    }

    public ExactTextsCaseSensitive(List<String> expectedTexts) {
        super(expectedTexts);
    }

    @Override
    @CheckReturnValue
    public boolean test(List<WebElement> elements) {
        if (elements.size() != this.expectedTexts.size()) {
            return false;
        }
        for (int i = 0; i < this.expectedTexts.size(); ++i) {
            WebElement element = elements.get(i);
            String expectedText = (String)this.expectedTexts.get(i);
            if (Html.text.equalsCaseSensitive(element.getText(), expectedText)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return "Exact texts case sensitive " + this.expectedTexts;
    }
}

