/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.MatcherError;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class PredicateCollectionCondition
extends CollectionCondition {
    protected final String matcher;
    protected final String description;
    protected final Predicate<WebElement> predicate;

    protected PredicateCollectionCondition(String matcher, String description, Predicate<WebElement> predicate) {
        this.matcher = matcher;
        this.description = description;
        this.predicate = predicate;
    }

    @Override
    public void fail(CollectionSource collection, @Nullable List<WebElement> elements, @Nullable Exception lastError, long timeoutMs) {
        if (elements == null || elements.isEmpty()) {
            ElementNotFound elementNotFound = new ElementNotFound(collection, this.toString(), (Throwable)lastError);
            elementNotFound.timeoutMs = timeoutMs;
            throw elementNotFound;
        }
        String expected = String.format("%s of elements to match [%s] predicate", this.matcher, this.description);
        throw new MatcherError(this.explanation, expected, ElementsCollection.elementsToString(collection.driver(), elements), collection, lastError, timeoutMs);
    }

    @Override
    public boolean missingElementSatisfiesCondition() {
        return false;
    }

    public String toString() {
        return String.format("%s match [%s] predicate", this.matcher, this.description);
    }
}

