/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.Arguments;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.WebElementSource;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SelectOptionByTextOrIndex
implements Command<Void> {
    private static final JavaScript selectOptionByIndex = new JavaScript("select-options-by-index.js");
    private static final JavaScript selectOptionByText = new JavaScript("select-options-by-text.js");

    @Override
    @Nullable
    public Void execute(SelenideElement proxy, WebElementSource selectField, @Nullable Object[] args) {
        List<String> texts;
        Arguments arguments = new Arguments(args);
        if (args == null || args.length == 0) {
            throw new IllegalArgumentException("Missing arguments");
        }
        Object object = args[0];
        if (object instanceof String) {
            String firstOptionText = (String)object;
            texts = Util.merge(firstOptionText, (String[])arguments.nth(1));
            this.selectOptionsByTexts(selectField, texts);
            return null;
        }
        texts = args[0];
        if (texts instanceof Integer) {
            Integer firstOptionIndex = (Integer)((Object)texts);
            int[] otherIndexes = (int[])arguments.nth(1);
            this.selectOptionsByIndexes(selectField, Util.merge(firstOptionIndex, otherIndexes));
            return null;
        }
        throw new IllegalArgumentException("Unsupported argument (expected String or Integer): " + Arrays.toString(args));
    }

    private void selectOptionsByTexts(WebElementSource selectField, List<String> texts) {
        Map error = (Map)selectOptionByText.execute(selectField.driver(), selectField.getWebElement(), texts);
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateException(selectField.driver(), selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List optionsTexts = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[text:%s]", selectField.description(), Util.arrayToString(optionsTexts));
            throw new InvalidStateException(selectField.driver(), elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List optionsTexts = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[text:%s]", selectField.getSearchCriteria(), Util.arrayToString(optionsTexts));
            throw new ElementNotFound(selectField.driver(), selectField.getAlias(), elementDescription, Condition.exist);
        }
    }

    private void selectOptionsByIndexes(WebElementSource selectField, List<Integer> indexes) {
        Map error = (Map)selectOptionByIndex.execute(selectField.driver(), selectField.getWebElement(), indexes);
        if (error.containsKey("disabledSelect")) {
            throw new InvalidStateException(selectField.driver(), selectField.description(), "Cannot select option in a disabled select");
        }
        if (error.containsKey("disabledOptions")) {
            List index = (List)Util.cast(error.get("disabledOptions"));
            String elementDescription = String.format("%s/option[index:%s]", selectField.description(), Util.arrayToString(index));
            throw new InvalidStateException(selectField.driver(), elementDescription, "Cannot select a disabled option");
        }
        if (error.containsKey("optionsNotFound")) {
            List index = (List)Util.cast(error.get("optionsNotFound"));
            String elementDescription = String.format("%s/option[index:%s]", selectField.getSearchCriteria(), Util.arrayToString(index));
            throw new ElementNotFound(selectField.driver(), selectField.getAlias(), elementDescription, Condition.exist);
        }
    }
}

