/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.commands;

import com.codeborne.selenide.Command;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.SetValueMethod;
import com.codeborne.selenide.SetValueOptions;
import com.codeborne.selenide.commands.Clear;
import com.codeborne.selenide.commands.Util;
import com.codeborne.selenide.ex.InvalidStateException;
import com.codeborne.selenide.impl.JavaScript;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.WebElementSource;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class SetValue
implements Command<SelenideElement> {
    private final JavaScript js = new JavaScript("set-value.js");
    private final Clear clear;

    public SetValue() {
        this(Plugins.inject(Clear.class));
    }

    protected SetValue(Clear clear) {
        this.clear = clear;
    }

    @Override
    @Nonnull
    public SelenideElement execute(SelenideElement proxy, WebElementSource locator, Object[] args) {
        Driver driver = locator.driver();
        SetValueOptions options = this.extractOptions(driver.config(), Objects.requireNonNull(args));
        this.setValueForTextInput(driver, locator, options);
        return proxy;
    }

    private SetValueOptions extractOptions(Config config, Object[] args) {
        Object object = args[0];
        if (object instanceof SetValueOptions) {
            SetValueOptions options = (SetValueOptions)object;
            return options;
        }
        CharSequence text = (CharSequence)Util.firstOf(args);
        return SetValueOptions.withText(text).usingMethod(config.fastSetValue() ? SetValueMethod.JS : SetValueMethod.SEND_KEYS);
    }

    private void setValueForTextInput(Driver driver, WebElementSource locator, SetValueOptions options) {
        WebElement element = locator.findAndAssertElementIsEditable();
        CharSequence value = (CharSequence)MoreObjects.firstNonNull((Object)options.value(), (Object)"");
        if (options.method() == SetValueMethod.JS) {
            String error = this.setValueByJs(driver, element, value);
            if (StringUtils.isNotEmpty((CharSequence)error)) {
                String elementDescription = locator.description();
                throw new InvalidStateException(driver, elementDescription, error);
            }
        } else if (value.length() > 0) {
            this.clear.clear(driver, element);
            element.sendKeys(new CharSequence[]{value});
        } else {
            this.clear.clearAndTrigger(driver, element);
        }
    }

    private String setValueByJs(Driver driver, WebElement element, CharSequence text) {
        return (String)this.js.execute(driver, element, text);
    }
}

