/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class AttributeWithValue
extends Condition {
    private final String attributeName;
    protected final String expectedAttributeValue;

    public AttributeWithValue(String attributeName, String expectedAttributeValue) {
        super(String.format("attribute %s=\"%s\"", attributeName, expectedAttributeValue));
        this.attributeName = attributeName;
        this.expectedAttributeValue = expectedAttributeValue;
    }

    @Override
    @Nonnull
    public CheckResult check(Driver driver, WebElement element) {
        String attributeValue = this.getAttributeValue(element);
        return new CheckResult(this.expectedAttributeValue.equals(attributeValue), (Object)String.format("%s=\"%s\"", this.attributeName, attributeValue));
    }

    protected String getAttributeValue(WebElement element) {
        String attr = element.getAttribute(this.attributeName);
        return attr == null ? "" : attr;
    }
}

