/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class Not
extends Condition {
    private final Condition condition;

    public Not(Condition originalCondition, boolean absentElementMatchesCondition) {
        super("not " + originalCondition.getName(), absentElementMatchesCondition);
        this.condition = originalCondition;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        CheckResult check = this.condition.check(driver, element);
        return new CheckResult(check.verdict() == CheckResult.Verdict.ACCEPT ? CheckResult.Verdict.REJECT : CheckResult.Verdict.ACCEPT, check.actualValue(), check.timestamp());
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return "not " + this.condition.toString();
    }
}

