/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.sessionstorage;

import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.SessionStorage;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Item
implements ObjectCondition<SessionStorage> {
    private final String item;

    public Item(String item) {
        this.item = item;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have item '%s'", this.item);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have item '%s'", this.item);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String actualValue(SessionStorage sessionStorage) {
        return sessionStorage.getItems().toString();
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.item;
    }

    @Override
    @CheckReturnValue
    public boolean test(SessionStorage sessionStorage) {
        return sessionStorage.containsItem(this.item);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(SessionStorage sessionStorage) {
        return "sessionStorage";
    }
}

