/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.BasicAuthCredentials;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
class BasicAuthUrl {
    BasicAuthUrl() {
    }

    @Nonnull
    String appendBasicAuthToURL(String url, @Nullable BasicAuthCredentials credentials) {
        if (credentials == null) {
            return url;
        }
        String domain = credentials.domain.isEmpty() ? "" : BasicAuthUrl.encode(credentials.domain) + "%5C";
        String login = credentials.login.isEmpty() ? "" : BasicAuthUrl.encode(credentials.login) + ':';
        String password = credentials.password.isEmpty() ? "" : BasicAuthUrl.encode(credentials.password) + "@";
        int index = url.indexOf("://");
        if (index < 0) {
            return domain + login + password + url;
        }
        return url.substring(0, index) + "://" + domain + login + password + url.substring(index + 3);
    }

    private static String encode(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

