/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.ex;

import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ListSizeMismatch
extends UIAssertionError {
    public ListSizeMismatch(String operator, int expectedSize, @Nullable String explanation, CollectionSource collection, @Nullable List<WebElement> actualElements, @Nullable Exception lastError, long timeoutMs) {
        super(collection.driver(), "List size mismatch: expected: " + operator + ' ' + expectedSize + (explanation == null ? "" : " (because " + explanation + ")") + ", actual: " + ListSizeMismatch.sizeOf(actualElements) + ", collection: " + collection.description() + System.lineSeparator() + "Elements: " + ElementsCollection.elementsToString(collection.driver(), actualElements), expectedSize, ListSizeMismatch.sizeOf(actualElements), lastError, timeoutMs);
    }

    @CheckReturnValue
    private static int sizeOf(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }
}

