/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.impl.HasTimeout;
import java.time.Duration;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class Arguments {
    private final Object[] args;

    public Arguments(Object ... args) {
        this.args = args;
    }

    @CheckReturnValue
    @Nonnull
    public <T> Optional<T> ofType(@Nonnull Class<T> klass) {
        if (this.args == null) {
            return Optional.empty();
        }
        for (Object arg : this.args) {
            if (arg == null || !klass.isAssignableFrom(arg.getClass())) continue;
            return Optional.of(arg);
        }
        return Optional.empty();
    }

    public <T> T nth(int index) {
        if (this.args == null) {
            throw new IllegalArgumentException("Missing arguments");
        }
        if (index >= this.args.length) {
            throw new IllegalArgumentException("Missing argument #" + index + " in " + Arrays.toString(this.args));
        }
        return (T)this.args[index];
    }

    @CheckReturnValue
    public long getTimeoutMs(long defaultTimeout) {
        return this.ofType(Duration.class).map(Duration::toMillis).orElseGet(() -> this.ofType(HasTimeout.class).map(HasTimeout::timeout).map(Duration::toMillis).orElse(defaultTimeout));
    }
}

