/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class FilteringCollection
implements CollectionSource {
    private final CollectionSource originalCollection;
    private final Condition filter;
    private Alias alias = Alias.NONE;

    public FilteringCollection(CollectionSource originalCollection, Condition filter) {
        this.originalCollection = originalCollection;
        this.filter = filter;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.originalCollection.getElements().stream().filter(webElement -> this.filter.check(this.originalCollection.driver(), (WebElement)webElement).verdict() == CheckResult.Verdict.ACCEPT).collect(Collectors.toList());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        return this.originalCollection.getElements().stream().filter(webElement -> this.filter.check(this.originalCollection.driver(), (WebElement)webElement).verdict() == CheckResult.Verdict.ACCEPT).skip(index).findFirst().orElseThrow(() -> new IndexOutOfBoundsException("Index: " + index));
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return this.originalCollection.description() + ".filter(" + this.filter + ')';
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.originalCollection.driver();
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

