/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.As;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.ElementsCollection;
import com.codeborne.selenide.ElementsContainer;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.PageObjectException;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementFinder;
import com.codeborne.selenide.impl.ElementsContainerCollection;
import com.codeborne.selenide.impl.LazyCollectionSnapshot;
import com.codeborne.selenide.impl.LazyWebElementSnapshot;
import com.codeborne.selenide.impl.PageObjectFactory;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.FindBy;
import org.openqa.selenium.support.FindBys;
import org.openqa.selenium.support.pagefactory.Annotations;
import org.openqa.selenium.support.pagefactory.DefaultElementLocatorFactory;
import org.openqa.selenium.support.pagefactory.DefaultFieldDecorator;
import org.openqa.selenium.support.pagefactory.ElementLocatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenidePageFactory
implements PageObjectFactory {
    private static final Logger logger = LoggerFactory.getLogger(SelenidePageFactory.class);

    @Override
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass> PageObjectClass page(Driver driver, Class<PageObjectClass> pageObjectClass) {
        try {
            Constructor<PageObjectClass> constructor = pageObjectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return this.page(driver, constructor.newInstance(new Object[0]));
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create new instance of " + pageObjectClass, e);
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public <PageObjectClass, T extends PageObjectClass> PageObjectClass page(Driver driver, T pageObject) {
        Type[] types = pageObject.getClass().getGenericInterfaces();
        this.initElements(driver, null, pageObject, types);
        return pageObject;
    }

    public void initElements(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes) {
        for (Class<?> proxyIn = page.getClass(); proxyIn != Object.class; proxyIn = proxyIn.getSuperclass()) {
            this.initFields(driver, searchContext, page, proxyIn, genericTypes);
        }
    }

    protected void initFields(Driver driver, @Nullable WebElementSource searchContext, Object page, Class<?> proxyIn, Type[] genericTypes) {
        Field[] fields;
        for (Field field : fields = proxyIn.getDeclaredFields()) {
            this.initField(driver, searchContext, page, genericTypes, field);
        }
    }

    protected void initField(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes, Field field) {
        Object value = this.createFieldValue(driver, searchContext, page, genericTypes, field);
        if (value != null) {
            this.setFieldValue(page, field, value);
        }
    }

    @Nullable
    @CheckReturnValue
    protected Object createFieldValue(Driver driver, @Nullable WebElementSource searchContext, Object page, Type[] genericTypes, Field field) {
        Object fieldValue = this.getFieldValue(page, field);
        if (fieldValue == null) {
            By selector = this.findSelector(driver, field);
            return this.decorate(page.getClass().getClassLoader(), driver, searchContext, field, selector, genericTypes);
        }
        As as = field.getAnnotation(As.class);
        if (as != null && fieldValue instanceof SelenideElement) {
            SelenideElement element = (SelenideElement)fieldValue;
            return element.as(as.value());
        }
        if (as != null && fieldValue instanceof ElementsCollection) {
            ElementsCollection collection = (ElementsCollection)fieldValue;
            return collection.as(as.value());
        }
        return null;
    }

    @Nonnull
    protected By findSelector(Driver driver, Field field) {
        return new Annotations(field).buildBy();
    }

    protected boolean shouldCache(Field field) {
        return new Annotations(field).isLookupCached();
    }

    protected void setFieldValue(Object page, Field field, Object value) {
        try {
            field.setAccessible(true);
            field.set(page, value);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to assign field " + field + " to value " + value, e);
        }
    }

    @CheckReturnValue
    @Deprecated
    protected boolean isInitialized(Object page, Field field) {
        return this.getFieldValue(page, field) != null;
    }

    @CheckReturnValue
    @Nullable
    protected Object getFieldValue(Object page, Field field) {
        try {
            field.setAccessible(true);
            return field.get(page);
        }
        catch (IllegalAccessException e) {
            throw new PageObjectException("Failed to access field " + field + " in " + page, e);
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer createElementsContainer(Driver driver, @Nullable WebElementSource searchContext, Field field, By selector) {
        try {
            WebElementSource self = new ElementFinder(driver, searchContext, selector, 0);
            if (this.shouldCache(field)) {
                self = new LazyWebElementSnapshot(self);
            }
            return this.initElementsContainer(driver, field, self);
        }
        catch (ReflectiveOperationException e) {
            throw new PageObjectException("Failed to create elements container for field " + field.getName(), e);
        }
    }

    @CheckReturnValue
    @Nonnull
    ElementsContainer initElementsContainer(Driver driver, Field field, WebElementSource self) throws ReflectiveOperationException {
        Type[] typeArray;
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            typeArray = parameterizedType.getActualTypeArguments();
        } else {
            typeArray = new Type[]{};
        }
        Type[] genericTypes = typeArray;
        return this.initElementsContainer(driver, field, self, field.getType(), genericTypes);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public ElementsContainer initElementsContainer(Driver driver, Field field, WebElementSource self, Class<?> type, Type[] genericTypes) throws ReflectiveOperationException {
        if (Modifier.isInterface(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is interface");
        }
        if (Modifier.isAbstract(type.getModifiers())) {
            throw new IllegalArgumentException("Cannot initialize field " + field + ": " + type + " is abstract");
        }
        Constructor<?> constructor = type.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        ElementsContainer result = (ElementsContainer)constructor.newInstance(new Object[0]);
        this.initElements(driver, self, result, genericTypes);
        return result;
    }

    @CheckReturnValue
    @Nullable
    public final Object decorate(ClassLoader loader, Driver driver, @Nullable WebElementSource searchContext, Field field, By selector) {
        Type[] classGenericTypes = field.getDeclaringClass().getGenericInterfaces();
        return this.decorate(loader, driver, searchContext, field, selector, classGenericTypes);
    }

    @Nullable
    @CheckReturnValue
    private String alias(Field field) {
        As alias = field.getAnnotation(As.class);
        return alias == null ? null : alias.value();
    }

    @CheckReturnValue
    @Nullable
    public Object decorate(ClassLoader loader, Driver driver, @Nullable WebElementSource searchContext, Field field, By selector, Type[] genericTypes) {
        String alias = this.alias(field);
        if (ElementsContainer.class.equals(field.getDeclaringClass()) && "self".equals(field.getName())) {
            if (searchContext != null) {
                return ElementFinder.wrap(SelenideElement.class, searchContext);
            }
            logger.warn("Cannot initialize field {}", (Object)field);
            return null;
        }
        if (WebElement.class.isAssignableFrom(field.getType())) {
            return this.decorateWebElement(driver, searchContext, selector, field, alias);
        }
        if (ElementsCollection.class.isAssignableFrom(field.getType()) || this.isDecoratableList(field, genericTypes, WebElement.class)) {
            return this.createElementsCollection(driver, searchContext, selector, field, alias);
        }
        if (ElementsContainer.class.isAssignableFrom(field.getType())) {
            return this.createElementsContainer(driver, searchContext, field, selector);
        }
        if (this.isDecoratableList(field, genericTypes, ElementsContainer.class)) {
            return this.createElementsContainerList(driver, searchContext, field, genericTypes, selector);
        }
        return this.defaultFieldDecorator(driver, searchContext).decorate(loader, field);
    }

    @Nonnull
    protected SelenideElement decorateWebElement(Driver driver, @Nullable WebElementSource searchContext, By selector, Field field, @Nullable String alias) {
        return this.shouldCache(field) ? LazyWebElementSnapshot.wrap(new ElementFinder(driver, searchContext, selector, 0, alias)) : ElementFinder.wrap(driver, SelenideElement.class, searchContext, selector, 0, alias);
    }

    @Nonnull
    protected ElementsCollection createElementsCollection(Driver driver, @Nullable WebElementSource searchContext, By selector, Field field, @Nullable String alias) {
        CollectionSource collection = new BySelectorCollection(driver, searchContext, selector);
        if (alias != null) {
            collection.setAlias(alias);
        }
        if (this.shouldCache(field)) {
            collection = new LazyCollectionSnapshot(collection);
        }
        return new ElementsCollection(collection);
    }

    @CheckReturnValue
    @Nonnull
    protected DefaultFieldDecorator defaultFieldDecorator(Driver driver, @Nullable WebElementSource searchContext) {
        WebDriver context = searchContext == null ? driver.getWebDriver() : searchContext.getWebElement();
        return new DefaultFieldDecorator((ElementLocatorFactory)new DefaultElementLocatorFactory((SearchContext)context));
    }

    @CheckReturnValue
    @Nonnull
    protected List<ElementsContainer> createElementsContainerList(Driver driver, @Nullable WebElementSource searchContext, Field field, Type[] genericTypes, By selector) {
        Class<?> listType = this.getListGenericType(field, genericTypes);
        if (listType == null) {
            throw new IllegalArgumentException("Cannot detect list type for " + field);
        }
        CollectionSource collection = new BySelectorCollection(driver, searchContext, selector);
        if (this.shouldCache(field)) {
            collection = new LazyCollectionSnapshot(collection);
        }
        return new ElementsContainerCollection(this, driver, field, listType, genericTypes, collection);
    }

    @CheckReturnValue
    protected boolean isDecoratableList(Field field, Type[] genericTypes, Class<?> type) {
        if (!List.class.isAssignableFrom(field.getType())) {
            return false;
        }
        Class<?> listType = this.getListGenericType(field, genericTypes);
        return listType != null && type.isAssignableFrom(listType) && (field.getAnnotation(FindBy.class) != null || field.getAnnotation(FindBys.class) != null);
    }

    @CheckReturnValue
    @Nullable
    protected Class<?> getListGenericType(Field field, Type[] genericTypes) {
        Type fieldType = field.getGenericType();
        if (!(fieldType instanceof ParameterizedType)) {
            return null;
        }
        Type[] actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments();
        Type firstType = actualTypeArguments[0];
        if (firstType instanceof TypeVariable) {
            int indexOfType = this.indexOf(field.getDeclaringClass(), firstType);
            return (Class)genericTypes[indexOfType];
        }
        if (firstType instanceof Class) {
            Class classType = (Class)firstType;
            return classType;
        }
        throw new IllegalArgumentException("Cannot detect list type of " + field);
    }

    protected int indexOf(Class<?> klass, Type firstArgument) {
        Object[] objects = Arrays.stream(klass.getTypeParameters()).toArray();
        for (int i = 0; i < objects.length; ++i) {
            if (!objects[i].equals(firstArgument)) continue;
            return i;
        }
        return -1;
    }
}

