/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Driver;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.CollectionSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class WebElementsCollectionWrapper
implements CollectionSource {
    private final List<WebElement> elements;
    private final Driver driver;
    private Alias alias = Alias.NONE;

    public WebElementsCollectionWrapper(Driver driver, Collection<? extends WebElement> elements) {
        this.driver = driver;
        this.elements = new ArrayList<WebElement>(elements);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public List<WebElement> getElements() {
        return this.elements;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public WebElement getElement(int index) {
        return this.elements.get(index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String getSearchCriteria() {
        return "$$(" + this.elements.size() + " elements)";
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.alias.getOrElse(() -> this.getSearchCriteria());
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public Driver driver() {
        return this.driver;
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @Override
    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }
}

