/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl.windows;

import java.util.ArrayList;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;

@ParametersAreNonnullByDefault
public class WindowByIndex
implements ExpectedCondition<WebDriver> {
    private final int index;

    public WindowByIndex(int index) {
        this.index = index;
    }

    @Nullable
    public WebDriver apply(WebDriver driver) {
        try {
            ArrayList windowHandles = new ArrayList(driver.getWindowHandles());
            return driver.switchTo().window((String)windowHandles.get(this.index));
        }
        catch (IndexOutOfBoundsException windowWithIndexNotFound) {
            return null;
        }
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return "window to be available by index: " + this.index;
    }
}

