/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.impl.DurationFormat;
import java.time.Duration;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;

public class ArgumentsPrinter {
    private static final DurationFormat df = new DurationFormat();

    @CheckReturnValue
    @Nonnull
    static String readableArguments(Object ... args) {
        Object object;
        if (args == null || args.length == 0) {
            return "";
        }
        if (args.length == 1 && (object = args[0]) instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            return ArgumentsPrinter.arrayToString(objectArray);
        }
        if (args.length == 1 && (object = args[0]) instanceof int[]) {
            int[] intArray = (int[])object;
            return ArgumentsPrinter.arrayToString(intArray);
        }
        return ArgumentsPrinter.arrayToString(args);
    }

    @CheckReturnValue
    @Nonnull
    private static String arrayToString(Object[] args) {
        String string;
        Object[] argsWithoutEmptyVarargs = ArgumentsPrinter.argsWithoutEmptyVarargs(args);
        switch (argsWithoutEmptyVarargs.length) {
            case 0: {
                string = "";
                break;
            }
            case 1: {
                string = ArgumentsPrinter.argToString(argsWithoutEmptyVarargs[0]);
                break;
            }
            default: {
                string = '[' + Stream.of(argsWithoutEmptyVarargs).map(ArgumentsPrinter::argToString).collect(Collectors.joining(", ")) + ']';
            }
        }
        return string;
    }

    @CheckReturnValue
    @Nonnull
    private static Object[] argsWithoutEmptyVarargs(Object[] args) {
        if (args.length < 2) {
            return args;
        }
        Object last = args[args.length - 1];
        if (last == null || !last.getClass().isArray()) {
            return args;
        }
        return ArgumentsPrinter.mergePreviousArgWithVararg(args, last);
    }

    @Nonnull
    private static Object[] mergePreviousArgWithVararg(Object[] args, Object last) {
        Object[] objects;
        Object previous = args[args.length - 2];
        if (last instanceof int[]) {
            int[] integers = (int[])last;
            if (previous instanceof Integer) {
                return ArgumentsPrinter.mergeArrays(args, integers);
            }
        }
        if (last instanceof Object[] && ArgumentsPrinter.isSameClass(previous, objects = (Object[])last)) {
            return ArgumentsPrinter.mergeArrays(args, objects);
        }
        return args;
    }

    @Nonnull
    private static Object[] mergeArrays(Object[] args, int[] integers) {
        Object[] mergedArgs = new Object[args.length - 1 + integers.length];
        System.arraycopy(args, 0, mergedArgs, 0, args.length - 1);
        ArgumentsPrinter.arrayCopy(integers, mergedArgs, args.length - 1);
        return mergedArgs;
    }

    @Nonnull
    private static Object[] mergeArrays(Object[] args, Object[] objects) {
        Object[] mergedArgs = new Object[args.length - 1 + objects.length];
        System.arraycopy(args, 0, mergedArgs, 0, args.length - 1);
        System.arraycopy(objects, 0, mergedArgs, args.length - 1, objects.length);
        return mergedArgs;
    }

    private static boolean isSameClass(Object previous, Object[] objects) {
        return previous.getClass() == objects.getClass().getComponentType();
    }

    private static void arrayCopy(int[] source, Object[] destination, int destinationPosition) {
        for (int i = 0; i < source.length; ++i) {
            destination[destinationPosition + i] = source[i];
        }
    }

    @CheckReturnValue
    @Nonnull
    private static String argToString(Object arg) {
        if (arg instanceof Duration) {
            Duration duration = (Duration)arg;
            return df.format(duration);
        }
        if (arg instanceof Object[]) {
            Object[] array = (Object[])arg;
            return Arrays.toString(array);
        }
        return String.valueOf(arg);
    }

    @CheckReturnValue
    @Nonnull
    private static String arrayToString(int[] args) {
        return args.length == 1 ? String.valueOf(args[0]) : Arrays.toString(args);
    }
}

