/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.ArgumentsPrinter;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.LogEventListener;
import com.codeborne.selenide.logevents.SelenideLog;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class SelenideLogger {
    private static final Logger LOG = LoggerFactory.getLogger(SelenideLogger.class);
    private static final ThreadLocal<Map<String, LogEventListener>> listeners = new ThreadLocal();
    private static final Pattern REGEX_UPPER_CASE = Pattern.compile("([A-Z])");

    public static void addListener(String name, LogEventListener listener) {
        Map<String, LogEventListener> threadListeners = listeners.get();
        if (threadListeners == null) {
            threadListeners = new HashMap<String, LogEventListener>();
        }
        threadListeners.put(name, listener);
        listeners.set(threadListeners);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideLog beginStep(String source, String methodName, Object ... args) {
        return SelenideLogger.beginStep(source, SelenideLogger.getReadableSubject(methodName, args));
    }

    @CheckReturnValue
    @Nonnull
    public static String getReadableSubject(String methodName, Object ... args) {
        return SelenideLogger.readableMethodName(methodName) + "(" + ArgumentsPrinter.readableArguments(args) + ")";
    }

    @CheckReturnValue
    @Nonnull
    static String readableMethodName(String methodName) {
        return REGEX_UPPER_CASE.matcher(methodName).replaceAll(" $1").toLowerCase(Locale.ROOT);
    }

    @CheckReturnValue
    @Nonnull
    public static SelenideLog beginStep(String source, String subject) {
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        SelenideLog log = new SelenideLog(source, subject);
        for (LogEventListener listener : listeners) {
            try {
                listener.beforeEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
        return log;
    }

    public static void commitStep(SelenideLog log, Throwable error) {
        log.setError(error);
        SelenideLogger.commitStep(log, LogEvent.EventStatus.FAIL);
    }

    public static void commitStep(SelenideLog log, LogEvent.EventStatus status) {
        log.setStatus(status);
        Collection<LogEventListener> listeners = SelenideLogger.getEventLoggerListeners();
        for (LogEventListener listener : listeners) {
            try {
                listener.afterEvent(log);
            }
            catch (RuntimeException e) {
                LOG.error("Failed to call listener {}", (Object)listener, (Object)e);
            }
        }
    }

    public static void run(String source, String subject, Runnable runnable) {
        SelenideLog log = SelenideLogger.beginStep(source, subject);
        try {
            runnable.run();
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    @CheckReturnValue
    public static <T> T get(String source, String subject, Supplier<T> supplier) {
        SelenideLog log = SelenideLogger.beginStep(source, subject);
        try {
            T result = supplier.get();
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return result;
        }
        catch (Error | RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    @CheckReturnValue
    @Nonnull
    private static Collection<LogEventListener> getEventLoggerListeners() {
        if (listeners.get() == null) {
            listeners.set(new HashMap());
        }
        return listeners.get().values();
    }

    @Nullable
    public static <T extends LogEventListener> T removeListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return (T)(listeners == null ? null : listeners.remove(name));
    }

    public static void removeAllListeners() {
        listeners.remove();
    }

    public static boolean hasListener(String name) {
        Map<String, LogEventListener> listeners = SelenideLogger.listeners.get();
        return listeners != null && listeners.containsKey(name);
    }
}

