/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.logevents;

import com.codeborne.selenide.logevents.EventsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.util.List;
import java.util.OptionalInt;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.NOPLogger;
import org.slf4j.helpers.NOPLoggerFactory;

@ParametersAreNonnullByDefault
public class SimpleReport {
    private static final Logger log = LoggerFactory.getLogger(SimpleReport.class);
    private static final int MIN_FIRST_COLUMN_WIDTH = 20;
    private static final int MAX_SECOND_COLUMN_WIDTH = 70;

    public void start() {
        SimpleReport.checkThatSlf4jIsConfigured();
        SelenideLogger.addListener("simpleReport", new EventsCollector());
    }

    public void finish(String title) {
        EventsCollector logEventListener = (EventsCollector)SelenideLogger.removeListener("simpleReport");
        if (logEventListener == null) {
            log.warn("Can not publish report because Selenide logger has not started.");
            return;
        }
        String report = this.generateReport(title, logEventListener.events());
        log.info(report);
    }

    @Nonnull
    @CheckReturnValue
    String generateReport(String title, List<LogEvent> events) {
        int firstColumnWidth = Math.max(this.maxLocatorLength(events).orElse(0), 20);
        int secondColumnWidth = Math.min(this.maxSubjectLength(events).orElse(7), 70);
        int estimatedReportLength = 20 + title.length() + (firstColumnWidth + secondColumnWidth + 35) * (4 + events.size());
        ReportBuilder report = new ReportBuilder(firstColumnWidth, secondColumnWidth, estimatedReportLength);
        report.appendTitle(title);
        report.appendHeader();
        for (LogEvent e : events) {
            report.appendEvent(e);
        }
        report.appendDelimiterLine();
        return report.build();
    }

    @Nonnull
    @CheckReturnValue
    private OptionalInt maxLocatorLength(List<LogEvent> events) {
        return events.stream().map(LogEvent::getElement).map(String::length).mapToInt(Integer::intValue).max();
    }

    @Nonnull
    @CheckReturnValue
    private OptionalInt maxSubjectLength(List<LogEvent> events) {
        return events.stream().map(LogEvent::getSubject).map(String::length).mapToInt(Integer::intValue).max();
    }

    public void clean() {
        SelenideLogger.removeListener("simpleReport");
    }

    private static void checkThatSlf4jIsConfigured() {
        ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
        if (loggerFactory instanceof NOPLoggerFactory || loggerFactory.getLogger("com.codeborne.selenide") instanceof NOPLogger) {
            throw new IllegalStateException("SLF4J is not configured. You will not see any Selenide logs. " + System.lineSeparator() + "  Please add slf4j-simple.jar, slf4j-log4j12.jar or logback-classic.jar to your classpath. " + System.lineSeparator() + "  See https://github.com/selenide/selenide/wiki/slf4j");
        }
    }

    private static class ReportBuilder {
        private final int firstColumnWidth;
        private final int secondColumnWidth;
        private final String delimiterLine;
        private final StringBuilder sb;

        private ReportBuilder(int firstColumnWidth, int secondColumnWidth, int estimatedReportLength) {
            this.firstColumnWidth = firstColumnWidth;
            this.secondColumnWidth = secondColumnWidth;
            this.delimiterLine = '+' + String.join((CharSequence)"+", this.line(firstColumnWidth + 2), this.line(secondColumnWidth + 2), this.line(12), this.line(12)) + '+' + System.lineSeparator();
            this.sb = new StringBuilder(estimatedReportLength);
        }

        private void appendTitle(String title) {
            this.sb.append("Report for ").append(title).append(System.lineSeparator());
            this.sb.append(this.delimiterLine);
        }

        @CheckReturnValue
        @Nonnull
        private String line(int count) {
            StringBuilder sb = new StringBuilder(count);
            for (int i = 0; i < count; ++i) {
                sb.append('-');
            }
            return sb.toString();
        }

        public void appendHeader() {
            this.appendLine(this.sb, this.firstColumnWidth, this.secondColumnWidth, "Element", "Subject", "Status", "ms.");
            this.appendDelimiterLine();
        }

        private void appendLine(StringBuilder sb, int firstColumnWidth, int secondColumnWidth, String first, String second, String third, String fourth) {
            sb.append("| ");
            this.append(sb, first, firstColumnWidth);
            sb.append(" | ");
            this.append(sb, second, secondColumnWidth);
            sb.append(" | ");
            this.append(sb, third, 10);
            sb.append(" | ");
            this.append(sb, fourth, 10);
            sb.append(" |").append(System.lineSeparator());
        }

        private void appendEvent(LogEvent e) {
            this.appendLine(this.sb, this.firstColumnWidth, this.secondColumnWidth, e.getElement(), e.getSubject(), e.getStatus().name(), String.valueOf(e.getDuration()));
        }

        public void appendDelimiterLine() {
            this.sb.append(this.delimiterLine);
        }

        private void append(StringBuilder sb, String text, int minLength) {
            sb.append(text);
            for (int i = text.length(); i < minLength; ++i) {
                sb.append(' ');
            }
        }

        public String build() {
            return this.sb.toString();
        }
    }
}

