/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.proxy;

import com.browserup.bup.filters.ResponseFilter;
import com.browserup.bup.util.HttpMessageContents;
import com.browserup.bup.util.HttpMessageInfo;
import io.netty.handler.codec.http.HttpResponse;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class ResponseSizeWatchdog
implements ResponseFilter {
    private static final Logger log = LoggerFactory.getLogger(ResponseSizeWatchdog.class);
    private final int threshold = 0x400000;

    public void filterResponse(HttpResponse response, HttpMessageContents contents, HttpMessageInfo messageInfo) {
        if (contents.getBinaryContents().length > 0x400000) {
            log.warn("Too large response {}: {} bytes", (Object)messageInfo.getUrl(), (Object)contents.getBinaryContents().length);
            log.trace("Response content: {}", (Object)contents.getTextContents());
        }
    }
}

